package cn.com.duiba.api.enums;

/**
 * @author zhengjianhao
 * @date 18/12/4
 * @description
 */
public enum AppItemSourceTypeEnum {
	SourceTypeNormal(0, "普通兑换"),
	SourceTypeOperatingActivity(1, "运营活动创建的AppItem"),
	SourceTypeDuibaActivity(2, "兑吧专题活动"),
	SourceTypeSingleLottery(3, "单品抽奖活动"),
	SourceTypeManualLottery(4, "手动开奖活动"),
	SourceTypeDuibaActivityItem(5, "专题活动的兑换项入口"),
	SourceTypeDuibaActivitySingleLottery(6, "专题活动的单品抽奖的兑换项入口"),
	SourceTypeAppShakeLottery(7, "摇一摇抽奖"),
	SourceTypeAppScratchCardLottery(8, "刮刮卡抽奖"),
	SourceTypeHdtoolTiger(9, "老虎机"),
	SourceTypeHdtoolTurntable(10, "活动工具大转盘"),
	SourceTypeHdtoolFlop(12, "活动工具趣味翻牌"),
	SourceTypeHdtoolSmashg(13, "活动工具砸彩蛋"),
	SourceTypeSecondsKill(11, "秒杀专题"),
	SourceTypeGameSanta(20, "游戏，打劫圣诞老人"),
	SourceTypeGameYearAward(21, "游戏，数年终奖"),
	SourceTypeGameGirl(22, "游戏，女神pk"),
	SourceTypeGameJiong(23, "游戏，人在囧途"),
	SourceTypeDuibaQuestionAnswer(30, "兑吧答题活动"),
	SourceTypeDuibaQuizz(41, "兑吧测试题活动"),
	SourceTypeDuibaSeckill(40, "秒杀活动"),
	SourceTypeDuibaNgame(28, "新游戏"),
	SourceTypeDuibaGuess(42, "兑吧竞猜"),
	SourceTypeNgame(28, "新游戏"),
	SourceTypeGuess(42, "竞猜"),
	SourceTypeCreditGame(46, "积分游戏");

	private int code;
	private String desc;

	private AppItemSourceTypeEnum(int code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public int getCode() {
		return this.code;
	}

	public String getDesc() {
		return this.desc;
	}

	public static AppItemSourceTypeEnum getAppItemSourceTypeEnum(int code) {
		AppItemSourceTypeEnum[] values = values();
		AppItemSourceTypeEnum[] arr$ = values;
		int len$ = values.length;

		for(int i$ = 0; i$ < len$; ++i$) {
			AppItemSourceTypeEnum value = arr$[i$];
			if (value.getCode() == code) {
				return value;
			}
		}

		return null;
	}
}