package cn.com.duiba.api.enums.subcredits;

/**
 * 扣积分业务类型
 */
public enum SubCreditsType {

    /**
     * 普通兑换
     */
    MALL("mall"),

    /**
     * 活动工具
     */
    HDTOOL("hdtool"),

    /**
     * 插件
     */
    PLUGIN("plugin"),

    /**
     * 单品抽奖
     */
    SINGLELOTTERY("singleLottery"),


    /**
     * 补签消耗
     **/
    RE_SIGN_CONSUME("reSignConsume"),

    /**
     * 补签加积分
     **/
    RE_SIGN_ADD_CREDITS("reSignAddCredits"),

    /**
     * 押注活动
     */
    BET_ACTIVITY("betActivity"),

    /**
     * 博彩活动
     */
    LOTTERY_BET("lotteryBet"),

    /**
     * 手动开奖
     */
    MANUANL_LOTTERY("manualLottery"),

    /**
     * 新游戏
     */
    NGAME_LOTTERY("ngameLottery"),

    /**
     * 签到契约参与扣积分
     */
    SIGN_CONTRACT_BET("signContractBet"),

    /**
     * 签到养成道具购买扣积分
     */
    SIGN_PET_TOY("signPetToy"),

    /**
     * 冲顶大会
     */
    MILLIONAIRE("millionaire"),

    /**
     * 支付宝
     */
    ALIPAY("alipay"),

    /**
     * Q币
     */
    QB("qb"),

    /**
     * 优惠券
     */
    COUPON("coupon"),

    /**
     * 实物
     */
    OBJECT("object"),

    /**
     * 话费
     */
    PHONE_BILL("phonebill"),

    /**
     * 流量
     */
    PHONE_FLOW("phoneflow"),

    /**
     * 虚拟商品
     */
    VIRTUAL("virtual"),

    /**
     * 种红包活动
     */
    SEED_RED_PACKET("seedredpacket"),

    /**
     * 暑期活动购买道具扣积分
     */
    SUMMER_TOY("summerToy"),

    /**
     * 签到养成出行
     */
    SIGN_PET_TRAVEL("signPetTravel")
    ;

    private final String msg;

    SubCreditsType(String msg) {
        this.msg = msg;
    }

    public String getMsg() {
        return msg;
    }
}