package cn.com.duiba.api.tools;

import java.io.Serializable;

/**
 * @author zhengjianhao
 * @date 18/12/4
 * @description
 */
public abstract class Tuple implements Serializable {
	private static final long serialVersionUID = -8719929625763890301L;

	public Tuple() {
	}

	public static <A, B> Tuple.Tuple2<A, B> tuple(A a, B b) {
		return new Tuple.Tuple2(a, b);
	}

	public static <A, B, C, D, E> Tuple.Tuple3<A, B, C> tuple(A a, B b, C c) {
		return new Tuple.Tuple3(a, b, c);
	}

	public static final class Tuple3<A, B, C> extends Tuple implements Serializable {
		private static final long serialVersionUID = 482545776907024161L;
		private A a;
		private B b;
		private C c;

		private Tuple3() {
		}

		private Tuple3(A a, B b, C c) {
			this.a = a;
			this.b = b;
			this.c = c;
		}

		public A _1() {
			return this.a;
		}

		public B _2() {
			return this.b;
		}

		public C _3() {
			return this.c;
		}
	}

	public static final class Tuple2<A, B> extends Tuple implements Serializable {
		private static final long serialVersionUID = 7263645006696591632L;
		private A a;
		private B b;

		private Tuple2() {
		}

		private Tuple2(A a, B b) {
			this.a = a;
			this.b = b;
		}

		public A _1() {
			return this.a;
		}

		public B _2() {
			return this.b;
		}
	}
}