package cn.com.duiba.api.enums.errorCode;

/**
 * Created by xutao on 2019/2/25.
 */
public enum TradeAccessWebExEnum {
    E1006001001("1006001001", "商品兑换已达次数上限"),
    E1006001002("1006001002", "扣预算失败"),
    E1006001003("1006001003", "获取扣减库存商品信息参数为空"),
    E1006001004("1006001004", "扣库存失败"),
    E1006001005("1006001005", "兑换劵已经用完"),
    E1006001006("1006001006", "已兑完"),
    E999999999("999999999", "系统异常，请稍后重试！"),;
    ;
    private String code;
    private String desc;
    private String subDesc;

    TradeAccessWebExEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    TradeAccessWebExEnum(TradeAccessWebExEnum exEnum, String subDesc) {
        exEnum.setSubDesc(subDesc);
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getSubDesc() {
        return subDesc;
    }

    public void setSubDesc(String subDesc) {
        this.subDesc = subDesc;
    }
}
