package cn.com.duiba.api.tools;

import org.apache.commons.lang.StringUtils;

/**
 * 业务上http请求工具类
 */
public class HttpRequestBizUtil {

    private static final String UA_ID_WX = "micromessenger";
    private static final String UA_ID_QQ = "qq";
    private static final String UA_ID_ALIPAY = "alipay";

    /**
     * 通过User-Agent判断流量来源环境：1.微信;2.QQ;3.支付宝;4.其他，提供给tuia-engine使用
     *
     * @param userAgent
     * @return
     */
    public static int parseEnv4Engine(String userAgent) {
        if (StringUtils.isEmpty(userAgent)) {
            return 4;
        }
        String userAgentLower = userAgent.toLowerCase();
        if (userAgentLower.contains(UA_ID_WX)) {
            return 1;
        }
        if (userAgentLower.contains(UA_ID_QQ)) {
            return 2;
        }
        if (userAgentLower.contains(UA_ID_ALIPAY)) {
            return 3;
        }
        return 4;
    }
}
