package cn.com.duiba.api.bo.mq.alarmsms;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;

/**
 * @Description: MQ处理参数（告警短信）
 * @Author: fxr
 * @Date: 2019/2/12
 */
public class AlarmSmsBaseParam implements Serializable {

    private static final long serialVersionUID = 5075793918337042920L;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 应用名称
     */
    private String appName;

    public AlarmSmsBaseParam(String phone, String appName) {
        this.phone = phone;
        this.appName = appName;
    }

    public AlarmSmsBaseParam() {
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return AlarmSmsBaseParam
     */
    public static <T> T decode(byte[] msg, Class<T> clazz) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, clazz);
    }
}

