package cn.com.duiba.api.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**
 * ClassName:ActivityTypeEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动工具出奖方式
 * @date 创建时间：2018/4/14  11:40
 * @since JDK 1.8
 **/
public enum ActivityTypeEnum {
    ACTIVITY_TOOL("hdtool","概率出奖",false),
    QUESTION_ANSWER("question","答题活动-题目数出奖",true),
    QUESTION_ANSWER_HDTOOL("qhdtool","答题活动-概率出奖",true),
    GAME_TOOL("game","游戏前置开奖",false),
    THROUGH("through","闯关游戏",true),
    NGAME("ngame","新游戏",true),
    CREDITS("credits","积分消耗-两重发奖",false),
//    GUESS_POKER("guessPoker","猜扑克",false),
    COIN_PUSHER("coinPusher","推币机",false)
    ;

    //后续操作key
    private String key;
    //名称
    private String name;
    //是否执行 后续操作  true 不执行，false 执行
    private boolean executeFlag;
    private static Map<String,ActivityTypeEnum> typeMap = Maps.newHashMap();
    private static List<ActivityTypeEnum> list = Lists.newArrayList();

    ActivityTypeEnum(String key,String name,boolean executeFlag){
        this.name = name;
        this.key = key;
        this.executeFlag = executeFlag;
    }

    public String getKey() {
        return key;
    }

    public String getName() {
        return name;
    }

    public boolean isExecuteFlag() {
        return executeFlag;
    }

    static{
        for(ActivityTypeEnum typeClass : ActivityTypeEnum.values()){
            typeMap.put(typeClass.getKey(),typeClass);
            list.add(typeClass);
        }
    }

    /**
     * 根据type获取具体枚举类型
     * @param key
     * @return
     */
    public static ActivityTypeEnum getByType(String key){
        return typeMap.get(key);
    }

    /**
     * 获取全部 枚举值和名称
     * @return
     */
    public static List<ActivityTypeEnum> getAll(){
        return list;
    }
}
