package cn.com.duiba.api.enums;

import java.util.HashMap;

/**
 * 活动统一编码,新定义code从200起步
 * Created by xiaoxuda on 2019/1/14.
 * 维护文档：http://cf.dui88.com/pages/viewpage.action?pageId=13682861
 */
public enum  ActivityUniformityTypeEnum {
    //旧活动兼容，code与op表type一致
    AppSingleLottery(3, "自有单品抽奖"),
    DuibaSingleLottery(2, "兑吧单品抽奖"),
    ManualLottery(5, "手动开奖"),
    Bargain(26, "砍价活动"),
    Group(25, "拼团活动"),
    DuibaNgame(28, "游戏"),
    DuibaElasticGifts(49, "弹层活动"),
    Plugin(50, "插件"),
    BarrageSign(51, "弹层签到"),
    LotteryActivity(52, "博彩活动"),
    PK(53, "pk活动"),
    HDTool(100, "活动工具"),
    QuestionAnswer(101, "答题"),
    //新类型，以200起步
    FloorSign(201, "楼层签到"),
    CalendarSign(202, "日历签到"),
    ContractSign(203, "契约签到"),
    PetSign(204, "宠物养成"),
    ManageSign(205, "经营性签到"),
    BrickMover(56, "搬砖工"),
    RedPacketSquare(54,"红包广场"),
    SeedRedPacket(208, "种红包"),
    StealRedPacket(210,"偷红包"),
    VoteTool(209, "投票工具"),
    AppNewSeckill(211, "秒杀活动"),
    HappyGroup(212, "拼拼乐拼团活动"),
    SeedRedPacket_Old(213, "旧版种红包"),

    /**
     * 通用化的活动类型对应code定义：以3开头
     */
    FreeGroupTool(31002, "0元拼团工具"),

    /**
     * 定制化活动类型,从50001起自增
     */
    PiaoLiuXia_SignIn(50001,"漂流侠扑克牌签到"),
    YongHuiCollectCard_THREE(50002,"永辉集卡三期"),

    ;

    private static HashMap<Integer, ActivityUniformityTypeEnum> typeMap = new HashMap<>();
    static{
        for(ActivityUniformityTypeEnum type : values()){
            typeMap.put(type.getCode(), type);
        }
    }

    public static ActivityUniformityTypeEnum getByCode(Integer code){
        return typeMap.get(code);
    }

    private Integer code;
    private String desc;

    ActivityUniformityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
