package cn.com.duiba.api.bo.collectcard;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * 集卡开奖回调消息dto
 * @Author chenxiangge
 * @Date 2019/2/19
 */
public class CollectCardCallbackMsgDto implements Serializable {

    private static final long serialVersionUID = 8102953441885462292L;
    /**
     * 扩展参数
     */
    private Map<String, String> params;

    /**
     * appId
     */
    private Long appId;
    /**
     * 用户id
     */
    private Long consumerId;
    /**
     * 订单号
     */
    private String orderNum;

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return CollectCardCallbackMsgDto
     */
    public static CollectCardCallbackMsgDto decode(byte[] msg) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, CollectCardCallbackMsgDto.class);
    }
}
