package cn.com.duiba.api.bo.subcredits;

import cn.com.duiba.api.tools.GZIPCompressUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;

/**
 * 扣积分结果回调类
 * Created by hww on 2019/3/4 11:44 AM.
 */
public class SubCreditsBusinessResult implements Serializable {

    private static final long serialVersionUID = -1972064226956921190L;

    /** 透传业务参数 由业务方传输过来 回调时进行返传 */
    private String transfer;
    /** 业务订单号 */
    private String orderNum;
    /** 失败原因 */
    private String errorMsg;

    public boolean isSuccess() {
        return StringUtils.isBlank(errorMsg);
    }

    public String getTransfer() {
        return transfer;
    }

    public void setTransfer(String transfer) {
        this.transfer = transfer;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg
     * @return
     */
    public static SubCreditsBusinessResult decode(byte[] msg) {
        String string = GZIPCompressUtil.ungzip(msg);
        if (string == null || string.isEmpty()) {
            return null;
        }
        return JSONObject.parseObject(string, SubCreditsBusinessResult.class);
    }

    /**
     * 编码消息，发送时使用
     *
     * @param subCreditsMsg
     * @return
     */
    public static byte[] encode(SubCreditsBusinessResult subCreditsMsg) {
        String string = JSONObject.toJSONString(subCreditsMsg);
        try {
            byte[] str = string.getBytes("utf-8");
            return GZIPCompressUtil.gzip(str);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}
