package cn.com.duiba.api.enums.wallet;

/**
 * ClassName:RedisKeySpace<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 用于管理使用Redis的所有key前缀，避免业务key重复
 * 例如<br/>
 * K001("xxx业务缓存"),<br/>
 * K002("xxx业务分布式锁"), <br/>
 * K003("xxx业务计数器");<br/>
 * @date 创建时间：2018/3/13  17:19
 * @since JDK 1.8
 **/
public enum RedisKeySpace {

    K001("全局钱包结算开始时间"),
    K002("全局钱包结算结束时间"),
    K003("连续登录天数");

    /**
     * 应用名称
     */
    private static final String SPACE = "BZT";

    private String desc;

    RedisKeySpace(String description) {
        this.desc = description;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
