package cn.com.duiba.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 奖励方式
 * Created by xiaoxuda on 2019/3/12.
 */
public enum RewardWayTypeEnum {
    NO(1, "无"),
    CREDITS(2, "积分"),
    RED(3, "红包"),
    CREDITS_AND_RED(4, "积分+红包"),
    PLUGIN_CHANCE(5, "插件抽奖机会"),
    PRIZE_POOL_CHANCE(6, "奖品池抽奖机会"),
    HDTOOL_CHANCE(7, "活动工具抽奖机会")

    ;
    private Integer code;
    private String desc;

    private static Map<Integer, RewardWayTypeEnum> codeMap = new HashMap<>();
    static{
        for(RewardWayTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static RewardWayTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    RewardWayTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
