package cn.com.duiba.api.bo.custom.funheadlines;

import java.io.Serializable;

/**
 * @Description:趣头条定制-应用映射
 *
 * ①、趣头条在上架一个兑吧的活动/游戏时，需要在其开放平台注册一个对应的应用(http://newidea4-gamecenter-frontend.1sapp.com/opencms/prod/index.html#)，多个活动/游戏对应多个应用
 * ②、扣积分定制时，因多个应用存在，需要通过一个标识来获取正确的应用信息，这里通过transfer参数来处理；
 * ③、在拼接免登陆时transfer 取值APPID（①中兑吧在趣头条开放平台所注册的应用），同时在thirdparty-server配置好APPID，AppKey的关系配置（①中兑吧在趣头条开放平台所注册的应用），扣积分时即可通过 transfer的值取对应APP信息
 *
 * @Author: fxr
 * @Date: 2019/4/8
 */
public class FunheadLinesAppMapping implements Serializable {

    private static final long serialVersionUID = -2781286842719196714L;

    /**
     * 一个对应的活动/游戏，在趣头条开放平台对应一个应用
     * 应用id
     */
    private String appId;

    /**
     * 应用AppKey
     */
    private String appkey;

    /**
     * 活动/游戏链接
     */
    private String redirect;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppkey() {
        return appkey;
    }

    public void setAppkey(String appkey) {
        this.appkey = appkey;
    }

    public String getRedirect() {
        return redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }
}

