package cn.com.duiba.api.enums;

/**
 * 用户账户操作子类型
 * 是对出账、入账动作的进一步细分
 */
public enum AccountSubTypeEnum {

    SUB_CASH_DRAW("提现", 0),

    SUB_ACTIVITY_INCOME("活动收入", 1),

    SUB_EXP_ADD("增加经验", 2)
    ;

    AccountSubTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
