package cn.com.duiba.api.enums.mq;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * ClassName:RocketMqTagEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: mq tag 枚举类
 * @date 创建时间：2018/4/21  10:27
 * @since JDK 1.8
 **/
public enum RocketMqTagEnum {

    SUB_CREDITS_NORMAL("sub_credits_normal", "常规扣积分"),
    SUB_CREDITS_ONLY("sub_credits_only", "只扣积分不发放奖品"),
    SUB_CREDITS_ZERO("sub_credits_zero","扣0积分"),
    SUB_CREDITS_PROJECT_X("sub_credits_project_x", "project-x扣积分"),
    SUB_CREDITS_ZERO_PROJECT_X("sub_credtis_zero_project_x", "project-x扣0积分"),
    TAKE_PRIZE("takePrize", "活动工具领奖"),
    TAKE_PRIZE_NGAME("takePrizeNgame", "活动工具领奖ngame"),
    TAKE_PRIZE_COIN_PUSHER("coinPusher", "推币机扣积分成功处理"),

    TAKE_PRIZE_PLUGIN("takePrizePlugin", "插件领奖"),
    TAKE_PRIZE_PLUGIN_HAIDILAO("takePrizePluginForHaidilao", "插件领奖"),
    TAKE_PRIZE_PLUGIN_COMMON("takePrizePluginCommon", "插件通用领奖"),
    TAKE_PRIZE_PLUGIN_SHUQI_PK("takePrizePluginShuQiPK", "插件领奖书旗春节组队pk"),
    TAKE_PRIZE_PLUGIN_ITEM("takePrizePluginItem", "插件指定商品id的发奖形式"),
    TAKE_PRIZE_ACTIVITY_CREDITS("takePrizeActivityCredits", "活动发放积分"),
    TAKE_PRIZE_THROUGH("takePrizeThrough", "活动工具-闯关游戏领奖"),
    TAKE_PRIZE_COLLECT_CARD_DIRECT("takePrizeCollectCardDirect", "集卡直接发奖"),
    
    TAKE_PRIZE_CUSTOMER("takePrizeCustomer", "活动工具自定义 主要为定制需求使用"),//废弃  后续 代码切换后 删除
    
    TAKE_PRIZE_APPLY("takePrizeApply", "通用奖品发放"),
    
    VISIT_TIME("vist", "活动参与次数"),

    JOIN_TIME("join","活动参与次数"),
    JOIN_TIME_PLUGIN("pluginJoin","插件活动参与次数"),
    JOIN_TIME_COMM("commJoin","通用参与次数"),

    KV_MUL_INSERT("mulInsert", "kv批量插入"),
    KV_INSERT_INCREASE("insertOrIncrease", "kv单条插入或者增长"),
    KV_INSERT_UPDATE("insertOrUpdate", "kv单条插入或者更新"),
    KV_BATCH_INCREASE("batchIncrease", "kv批量插入，用于搜狐新闻临时需求"),

    TH_SUB_CREDITS("tag_new", "第三方服务扣积分"),
    REFLECT_WALLET_RECORD("reflect_wallet_record","钱包账户流水体现更新"),
    NOTIFY_QUEUE_TAG("notify_queue_tag","通知开发者tag"),
    EXPIRE_WALLET_RECORD("expire_wallet_record","钱包账户流水过期更新"),
    KV_HB_BATCH_UPSERT("batchUpsert","kvtable HBase批量新增或更新的tags"),
    KV_HB_SINGLE_UPSERT("singleUpsert","kvtable HBase单条新增或更新tags"),
    THIRDPARTY_DING_TEXT_MSG("dingTextMsg","thirdParty服务中发送钉钉文本消息类型"),
    ACR_ADD_SCORE("addScore","activityRank 增加分数tag"),
    PRI_ADD_CREDITS("addCredits","prizeCenter 增加积分tag"),
    PRI_ADD_ACTIVITY_CREDITS("addActivityCredits", "活动加积分"),
    PROJECT_X_INCREASE_CREDITS("projectXIncreaseCredits", "project-x增加积分tag"),
    PRI_VIRTUAL("virtual","prizeCenter 虚拟商品tag"),
    // 供应商发货回调Tag
    //ssc = supplier_send_confirm
//    SSC_OBJECT("ssc_object","供应商实物确认发货"),
//    SSC_COUPON("ssc_coupon","供应商优惠券确认发货"),
//    SSC_ALIPAY("ssc_alipay","供应商支付宝确认发货"),
//    SSC_QB("ssc_qb","供应商QB确认发货"),
//    SSC_PHONEBILL("ssc_phonebill","供应商话费确认发货"),

    SMS_SUB_CREDITS_ALARM("subCreditsAlarm","短信告警服务-发送扣积分报警短信tag"),
    SMS_BALANCE_ALARM("balanceAlarm","短信告警服务-发送余额报警短信tag"),
    SMS_LS_BUDGET_WARN_ALARM("lotterySquareBudgetWarnAlarm","短信告警服务-红包广场-预算预警报警短信tag"),
    SMS_LS_BUDGET_RAN_OUT_ALARM("lotterySquareBudgetOutAlarm","短信告警服务-红包广场-预算用尽报警短信tag"),

    /**
     * 盈合麦田接口定制需求
     * 用户在兑换优惠券及活动领取优惠券时，兑吧券码发放后，通过接口告知开发者
     */
    YHMT_COUPON_USE_NOTIFY("yhmtCouponUseNotify","盈合麦田接口定制-优惠券使用通知tag"),

    /**
     * 万达接口定制需求
     * 用户在兑换优惠券，通过接口告知开发者(仅限开发者后台优惠券)
     */
    WANDA_COUPON_USE_NOTIFY("wandaCouponUseNotify","万达接口定制-优惠券使用通知tag"),

    /**
     * 应用宝组件化迁移定制需求
     * 发放新用户专享福利加积分tag
     */
    YYB_NEW_USER_BENEFITS("yybNewUserBenefits","应用宝组件化迁移定制-发放新用户专享福利加积分tag"),

    COIN_PUSHER_BALANCE_TAG("balance", "推币机提交余额tag"),

    DUIBA_ACCOUNT_RISK("duibaAccountRisk","兑吧账户支出预警"),

    TAG_QQ_MUSIC_AUCTION_SUB_CREDITS("qqMusicAuctionSubCredits", "qq音乐商品拍卖活动扣积分回调TAG"),

    NAN_JING_CITIC_ORDER_SUCCESS("nanjingCitic", "南京中信银行下单成功通知tag"),

    CMB_TIANJIN_SIGN_REMIND("cmbchina-tianjian-sign-push", "天津招行签到提醒tag"),

    CMB_TIANJIN_EXCHANGE_REMIND("cmbchina-tianjian-exchange-push","天津招行兑换提醒tag"),

    WEBANK_LOTTERY_DRAW_CHECK("webank-lottery-draw-check", "微众银行抽奖结果异常tag"),
    WEBANK_RECONCILIATION("webank-reconciliation", "微众银行对账tag"),
    WEBANK_SERVER_ERR_CHECK("webank-server-exception", "微众银行服务器异常tag"),
    WEBANK_REFRESH_ACCESS_TOKEN("webank-refresh-accesstoken", "微众银行刷新accesstoken tag"),
    WEBANK_REFRESH_SIGN_TICKET("webank-refresh-signticket", "微众银行刷新signticket tag"),
    WEBANK_STOCK_WARN("webank-stock-warn", "微众银行库存告警tag"),

    DALINGJIA_SIGN_REMIND("dalingjia-sign-remind","达令家签到推送"),
    ;

    public static final ImmutableMap<String, RocketMqTagEnum> ALL_TAG_MAP;

    static {
        Map<String, RocketMqTagEnum> temp = Maps.newHashMap();
        for (RocketMqTagEnum tag : values()) {
            temp.put(tag.getTag(), tag);
        }
        ALL_TAG_MAP = ImmutableMap.copyOf(temp);
    }

    /** tag名 */
    private String tag;
    /** 描述说明 */
    private String desc;

    RocketMqTagEnum(String tag, String desc) {
        this.tag = tag;
        this.desc = desc;
    }

    public String getTag() {
        return tag;
    }

    public String getDesc() {
        return desc;
    }
}
