package cn.com.duiba.api.enums.hbase;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/10/16 0016 11:20
 * 为了和之前区分开,建议使用H开头
 */
public enum CustomWebHBaseKeyEnum {
    H001("永辉膨胀红包-任务邀请记录"),
    H002("永辉膨胀红包-红包金额"),


    H999("默认不能使用");

    private String desc;

    CustomWebHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    /**
     * 定制活动web: activity-custom-web HBase key space
     */
    private static final String SPACE = "CUSWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }
}
