package cn.com.duiba.api.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;

/**
 * 链接相关工具类
 */
public class ParamEstimateUtils {
	private static Map<String,String> emailMap = Maps.newHashMap();
	static{
		emailMap.put("qq.com", "http://mail.qq.com");
		emailMap.put("gmail.com","http://mail.google.com");
		emailMap.put("sina.com","http://mail.sina.com.cn");
		emailMap.put("163.com","http://mail.163.com");
		emailMap.put("126.com","http://mail.126.com");
		emailMap.put("yeah.net","http://www.yeah.net");
		emailMap.put("sohu.com","http://mail.sohu.com");
		emailMap.put("tom.com","http://mail.tom.com");
		emailMap.put("sogou.com","http://mail.sogou.com");
		emailMap.put("139.com","http://mail.10086.cn");
		emailMap.put("hotmail.com","http://www.hotmail.com");
		emailMap.put("live.com","http://login.live.com");
		emailMap.put("live.cn","http://login.live.cn");
		emailMap.put("live.com.cn","http://login.live.com.cn");
		emailMap.put("189.com","http://webmail16.189.cn/webmail");
		emailMap.put("yahoo.com.cn","http://mail.cn.yahoo.com");
		emailMap.put("yahoo.cn","http://mail.cn.yahoo.com");
		emailMap.put("eyou.com","http://www.eyou.com");
		emailMap.put("21cn.com","http://mail.21cn.com");
		emailMap.put("188.com","http://www.188.com");
		emailMap.put("foxmail.coom","http://www.foxmail.com");
	}

	private static final ImmutableSet<String> SQL_SET = ImmutableSet.of(
			"DELETE","ASCII","UPDATE","SELECT","SUBSTR(","COUNT("," OR "," AND ","DROP","EXECUTE","EXEC","TRUNCATE","INTO","DECLARE","MASTER","%"
	);

	private ParamEstimateUtils(){}

	/**
	 * 根据邮箱后缀获取运营商邮箱
	 * @param email
	 * @return
     */
	public static String getEmailIndexURL(String email){
		if(!isEmail(email)){
			return null;
		}
		String temp = email.substring(email.lastIndexOf('@')+1);
		return emailMap.get(temp);
	}


	/**
	 * 验证字段中是否存在非法SQL注入内容
	 * @param p
	 * @return
	 */
	public static boolean isValid(String p) {
		if(StringUtils.isBlank(p)){
			return true;
		}
		String upperCase = p.toUpperCase();
		for(String item:SQL_SET){
			if(upperCase.indexOf(item) >= 0){
				return false;
			}
		}
		return true;
	}
	
	/**
	 * 检测邮箱地址是否合法
	 * @param email
	 * @return true合法 false不合法
	 */
	public static boolean isEmail(String email){
		if (StringUtils.isBlank(email)){
			return false;
		}
		Pattern p =  Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");//复杂匹配
		Matcher m = p.matcher(email);
		return m.matches();
	}
	
	/**
	 * 验证手机号码是否合法
	 * @param phone
	 * @return true 合法 false 不合法
	 */
	public static boolean isPhone(String phone){
		if(StringUtils.isEmpty(phone)){
			return false;
		}
		if (phone.length()!=11){
			return false;
		}
		Pattern p = Pattern.compile("[0-9]*");
		Matcher m = p.matcher(phone);
		return m.matches();
	}
	
}