package cn.com.duiba.api.enums.custom.kuwo;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description: 酷我音乐-养成活动，用户日常行为
 * @Author: fxr
 * @Date: 2019/9/2
 */
public enum KuwoEduUserActionEnum {
    /**
     * 个人任务 personal task
     */
    PT_PERSONAL_SIGN(1, "个人中心签到"),
    PT_COLLECTION_SONGS(2, "收藏歌曲"),
    PT_LISTEN_SONG(3, "收听歌曲"),
    PT_SHARE(4, "分享"),

    /**
     * 宠物交互 Pet interaction
     */
    PI_FEED(11, "喂食"),
    PI_PLAY(12, "玩耍"),
    PI_LEARN_MUSIC(13, "学音乐"),
    PI_CURE(14, "治疗");

    private Integer code;
    private String desc;

    KuwoEduUserActionEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static KuwoEduUserActionEnum valueOfCode(Integer code) {
        return Arrays.stream(KuwoEduUserActionEnum.values()).filter(obj -> Objects.equals(obj.code, code)).findFirst().orElse(null);
    }

    public static KuwoEduUserActionEnum valueOfDesc(String desc) {
        return Arrays.stream(KuwoEduUserActionEnum.values()).filter(obj -> Objects.equals(obj.desc, desc)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
