package cn.com.duiba.api.enums.freegroup;

/**
 * @Author: lufeng
 * @Description: 拼团工具 个人参团状态枚举
 * @Date: Created in 2019/3/14
 */
public enum GroupUserStatusEnum {

    GROUP_INVITING("已参团，邀请好友参团", 1),

    GROUP_WAITING_INVITE("已参团，等待团长邀请中", 2),

    GROUP_WAITING_OPEN_PRIZE("团已满员，等待开奖", 3),

    GROUP_FAIL_TIMEOUT("拼团失败，该团已失效", 4),

    GROUP_FAIL_NO_WIN("拼团失败，未中奖", 5),

    GROUP_SUC_NO_GET("拼团成功，待领取", 6),

    GROUP_SUC_GET("拼团成功，已领取", 7),

    GROUP_SUC_GET_PROCESSING("拼团成功，领取中", 8);

    GroupUserStatusEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
