package cn.com.duiba.api.bo.mq.prize;

import cn.com.duiba.api.enums.prize.PrizeApplyFlowEnum;
import cn.com.duiba.api.enums.prize.PrizeProcessTypeEnum;
import cn.com.duiba.api.enums.prize.PrizeRelTypeEnum;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 * 发奖请求消息 Created by xiaoxuda on 2019/3/21.
 **/
public class PrizeApplyParam implements Serializable {

	private static final long serialVersionUID = 7266947718733738119L;

	//处理逻辑类型
	private PrizeProcessTypeEnum processType;
	//奖品业务关联类型，对应兑换记录表的biz_no(relType_activityId)
	private PrizeRelTypeEnum prizeRelType;
	//业务ID，活动ID或者业务ID，relType下唯一
	private Long activityId;
	// 兑吧活动时 传递值 否则不要传递   如果传递了   直冲类商品 将扣 兑吧资金
	private Long duibaActivityId;
	// 活动名称
	private String title;
	// appId
	private Long appId;
	// consumerId
	private Long consumerId;
	private String partnerUserId;
	//ip
	private String ip;
	// 订单id
	private String orderNum;
	// request 中获取 获取不到可以为null
	private String transfer;
	//参与活动 扣除积分    可以为null 或者0
	private Long credits;
	//处理流程
	private List<PrizeApplyFlowEnum> prizeApplyFlow;
	
	/** 福袋 start */
	private String tag;// 兑吧活动身上打的标签 发放福袋时使用
	private String os;// 福袋发放使用
	private String soltId;// 福袋发放使用
	private String cookiesParams;
	private Integer channelType;
	private Integer opType;// 福袋发放使用 operatingActivity.getType()
	private Boolean proxy; //param.setProxy(requestParams.isProxy());
	private String userAgent;//cookie 字段 requestParams.getUserAgent()
	/** 福袋 end */

	public String getTag() {
		return tag;
	}
	public void setTag(String tag) {
		this.tag = tag;
	}
	public String getOs() {
		return os;
	}
	public void setOs(String os) {
		this.os = os;
	}
	public String getSoltId() {
		return soltId;
	}
	public void setSoltId(String soltId) {
		this.soltId = soltId;
	}
	public String getCookiesParams() {
		return cookiesParams;
	}
	public void setCookiesParams(String cookiesParams) {
		this.cookiesParams = cookiesParams;
	}
	public Integer getChannelType() {
		return channelType;
	}
	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}
	public Integer getOpType() {
		return opType;
	}
	public void setOpType(Integer opType) {
		this.opType = opType;
	}
	public Boolean getProxy() {
		return proxy;
	}
	public void setProxy(Boolean proxy) {
		this.proxy = proxy;
	}
	public String getUserAgent() {
		return userAgent;
	}
	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	/** 当 PrizeProcessTypeEnum.PRIZE_DIRECT 需要赋值 start */
	/** 兑吧商品ID */
	private Long itemId;
	/** 开发者商品ID */
	private Long appItemId;
	/** 奖项类型，同ItemDto.Type */
	private String prizeType;
	/** 奖项名称 */
	private String prizeName;
	/** 下面可以不用赋值 PrizeProcessTypeEnum.PRIZE_DIRECT 需要赋值 END */

	//按照mark顺序正序排列
	{
		prizeApplyFlow = new LinkedList<>();
        prizeApplyFlow.add(PrizeApplyFlowEnum.APPLY_PRIZE_RANDOM_DEFAULT);
        prizeApplyFlow.add(PrizeApplyFlowEnum.APPLY_PRIZE_ITEM_CHECK);
        prizeApplyFlow.add(PrizeApplyFlowEnum.APPLY_PRIZE_GRANT);
	}

	public PrizeProcessTypeEnum getProcessType() {
		return processType;
	}
	public void setProcessType(PrizeProcessTypeEnum processType) {
		this.processType = processType;
	}
	public PrizeRelTypeEnum getPrizeRelType() {
		return prizeRelType;
	}
	public void setPrizeRelType(PrizeRelTypeEnum prizeRelType) {
		this.prizeRelType = prizeRelType;
	}
	public Long getActivityId() {
		return activityId;
	}
	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public Long getConsumerId() {
		return consumerId;
	}
	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}
	public String getPartnerUserId() {
		return partnerUserId;
	}
	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}
	public String getIp() {
		return ip;
	}
	public void setIp(String ip) {
		this.ip = ip;
	}
	public String getOrderNum() {
		return orderNum;
	}
	public void setOrderNum(String orderNum) {
		this.orderNum = orderNum;
	}
	public String getTransfer() {
		return transfer;
	}
	public void setTransfer(String transfer) {
		this.transfer = transfer;
	}
	public Long getItemId() {
		return itemId;
	}
	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}
	public Long getAppItemId() {
		return appItemId;
	}
	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}
	public String getPrizeType() {
		return prizeType;
	}
	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}
	public String getPrizeName() {
		return prizeName;
	}
	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}
	public Long getCredits() {
		return credits;
	}
	public void setCredits(Long credits) {
		this.credits = credits;
	}
	public Long getDuibaActivityId() {
		return duibaActivityId;
	}
	public void setDuibaActivityId(Long duibaActivityId) {
		this.duibaActivityId = duibaActivityId;
	}

    /**
     * 返回flow流的拷贝
     * @return
     */
	public List<PrizeApplyFlowEnum> getPrizeApplyFlow() {
        List<PrizeApplyFlowEnum> ret = new LinkedList<>();
        ret.addAll(prizeApplyFlow);
		return ret;
	}

    /**
     * newFlow.mark做匹配，已经存在相同mark则替换原有的PrizeApplyFlowEnum，按照mark正序排列
     * @param newFlow
     */
	public void addNewFlow(PrizeApplyFlowEnum newFlow){
        int flag = 0;
        for(PrizeApplyFlowEnum flow : prizeApplyFlow){
            if(flow.getMark().equals(newFlow.getMark())){
                prizeApplyFlow.set(flag, newFlow);
                return;
            } else if(flow.getMark() > newFlow.getMark()){
                break;
            }
            ++flag;
        }
        prizeApplyFlow.add(flag, newFlow);
    }
}