package cn.com.duiba.api.bo.virtual;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.api.tools.GZIPCompressUtil;
import cn.com.duiba.credits.sdk.VirtualParams;

/**
 * ClassName:AddCreditsMsgDto<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 虚拟商品请求mq消息 
 * 
 * 官方文档地址 ：http://docs.duiba.com.cn/tech_doc_book/optional/virtual.html
 * 基于 cn.com.duiba.flowwork.supplier.VirtualSupplier2 改造
 * 
 * 不再提供  压缩和解压功能 需要请调用 wolf 包中 方法自行加密
 * 
 * @date 创建时间：2019/01/03 15:12
 * @since JDK 1.8
 **/
public class VirtualMsgDto implements Serializable {

	private static final long serialVersionUID = 9122779226907080669L;
	public static final String SUPPLIERDEVELOPERVIRTUAL="developer-virtual";//兑换虚拟商品
	public static final String SUPPLIEACTIVITYVIRTUAL="activity-virtual";//活动兑换虚拟商品
	/**
	 * 关联id，比如子订单id，主订单id等，方面问题定位
	 */
	private String orderId;
	/**
	 * 兑吧活动 不走主订单的 该值 与orderid 一致
	 */
	private String supplierOrderId;
	/**
	 * 活动类型
	 */
	private String supplierName;
	/**
	 * appId
	 */
	private Long appId;
	/**
	 * consumerId
	 */
	private Long consumerId;
	/**
	 * 请求地址
	 */
	private String httpUrl;
	/**
	 * 时间戳
	 */
	private Long timestamp = System.currentTimeMillis();
	/**
	 * mq回调topic
	 */
	private String callbackTopic;
	/**
	 * mq回调tag
	 */
	private String callbackTag;
	/**
	 * mq回调key
	 */
	private String callbackKey;
	/**
	 * 扩展参数
	 */
	private Map<String, String> params;
	/**
	 * 兑吧sdk加积分参数
	 */
	private VirtualParams virtualParams;
	/**
	 * appSecret
	 */
	private String appSecret;
	
	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getSupplierOrderId() {
		return supplierOrderId;
	}

	public void setSupplierOrderId(String supplierOrderId) {
		this.supplierOrderId = supplierOrderId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getHttpUrl() {
		return httpUrl;
	}

	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}

	public Long getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}

	public String getCallbackTopic() {
		return callbackTopic;
	}

	public void setCallbackTopic(String callbackTopic) {
		this.callbackTopic = callbackTopic;
	}

	public String getCallbackTag() {
		return callbackTag;
	}

	public void setCallbackTag(String callbackTag) {
		this.callbackTag = callbackTag;
	}

	public String getCallbackKey() {
		return callbackKey;
	}

	public void setCallbackKey(String callbackKey) {
		this.callbackKey = callbackKey;
	}

	public Map<String, String> getParams() {
		return params;
	}

	public void setParams(Map<String, String> params) {
		this.params = params;
	}

	public VirtualParams getVirtualParams() {
		return virtualParams;
	}

	public void setVirtualParams(VirtualParams virtualParams) {
		this.virtualParams = virtualParams;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	/**
	 * 解码消息，接收mq消息使用
	 *
	 * @param msg
	 * @return
	 */
	public static VirtualMsgDto decode(byte[] msg) {
		String string = GZIPCompressUtil.ungzip(msg);
		if (string == null || string.isEmpty()) {
			return null;
		}
		return JSONObject.parseObject(string, VirtualMsgDto.class);
	}

	/**
	 * 编码消息，发送时使用
	 *
	 * @param subCreditsMsg
	 * @return
	 */
	public static byte[] encode(VirtualMsgDto subCreditsMsg) {
		String string = JSONObject.toJSONString(subCreditsMsg);
		try {
			byte[] str = string.getBytes("utf-8");
			return GZIPCompressUtil.gzip(str);
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
}