package cn.com.duiba.api.enums.openredpacket;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: lufeng
 * @Description: 自定义账户提现环境枚举
 * @Date: Created in 2019/4/29
 */
public enum WithdrawEnvTypeEnum {

    APP(1, "仅APP内"),
    All(2, "不限环境"),
    ;

    private Integer code;
    private String desc;

    private static Map<Integer, WithdrawEnvTypeEnum> codeMap = new HashMap<>();
    static{
        for(WithdrawEnvTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static WithdrawEnvTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    WithdrawEnvTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
