package cn.com.duiba.api.tools.abc;

import org.apache.commons.lang.StringUtils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author qianjue
 * @date 2019/9/23
 * @description: 农业银行请求加密工具类
 */
public class SHAEncrypt4ABCUtils {

    /**
     * @param params
     * @return
     */
    public static String encrypt(Map<String,String> params){
        Map<String,String> descParams = new HashMap<>();
        params.forEach((key,value) ->{
            descParams.put(key.toLowerCase(),value);
        });
        List<String> keys = new ArrayList<>(descParams.keySet());
        Collections.sort(keys);
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            String values = descParams.get(key);
            if(StringUtils.isBlank(values)){
                continue;
            }
            sb.append(key).append("=").append(values).append("&");
        }
        String encryptStr = null;
        if(sb.length() > 0){
            encryptStr =  sb.toString().substring(0,sb.length()-1);
        }
        return encrypt(encryptStr);
    }


    public static String encrypt(String srcString){
        System.out.println("srcString is " + srcString);
        MessageDigest md = null;
        String strDes = null;
        byte[] bt = srcString.getBytes();
        try {
            md = MessageDigest.getInstance("SHA-256");
            md.update(bt);
            strDes = bytes2Hex(md.digest()); // to HexString
        } catch (NoSuchAlgorithmException e) {
            return null;
        }
        return strDes;
    }


    private static String bytes2Hex(byte[] bts) {
        StringBuilder des = new StringBuilder();
        String tmp;
        for (byte bt : bts) {
            tmp = (Integer.toHexString(bt & 0xFF));
            if (tmp.length() == 1) {
                des.append("0");
            }
            des.append(tmp);
        }
        return des.toString();
    }
}
