package cn.com.duiba.api.bo.addcredits;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import cn.com.duiba.api.tools.GZIPCompressUtil;
import cn.com.duiba.credits.sdk.AddCreditsParams;;

/**
 * ClassName:AddCreditsMsgDto<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 加积分请求mq消息 
 * 
 * 基于 cn.com.duiba.order.center.api.dto.CreditsMessage 改造
 * 
 * 不再提供  压缩和解压功能 需要请调用 wolf 包中 方法自行加密
 * 
 * @date 创建时间：2018/12/26 15:12
 * @since JDK 1.8
 **/
public class AddCreditsMsgDto implements Serializable {

	private static final long serialVersionUID = 4080531232005599039L;
	/**
	 * 关联id，比如子订单id，主订单id等，方面问题定位
	 */
	private String relationId;
	/**
	 * 活动类型，SubCreditsMsg.TYPE_*
	 */
	private String relationType;
	/**
	 * appId
	 */
	private Long appId;
	/**
	 * consumerId
	 */
	private Long consumerId;
	/**
	 * 请求类型：默认get
	 */
	private String httpType;
	/**
	 * 请求地址
	 */
	private String httpUrl;
	/**
	 * 时间戳
	 */
	private Long timestamp = System.currentTimeMillis();
	/**
	 * mq回调topic
	 */
	private String callbackTopic;
	/**
	 * mq回调tag
	 */
	private String callbackTag;
	/**
	 * mq回调key
	 */
	private String callbackKey;
	/**
	 * 用于组装post请求消息体
	 */
	private Map<String, String> authParams;
	/**
	 * 扩展参数
	 */
	private Map<String, String> params;
	/**
	 * 兑吧sdk加积分参数
	 */
	private AddCreditsParams addCreditsParams;

	public String getRelationId() {
		return relationId;
	}
	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}
	public String getRelationType() {
		return relationType;
	}
	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public Long getConsumerId() {
		return consumerId;
	}
	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}
	public String getHttpType() {
		return httpType;
	}
	public void setHttpType(String httpType) {
		this.httpType = httpType;
	}
	public String getHttpUrl() {
		return httpUrl;
	}
	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}
	public Long getTimestamp() {
		return timestamp;
	}
	public void setTimestamp(Long timestamp) {
		this.timestamp = timestamp;
	}
	public String getCallbackTopic() {
		return callbackTopic;
	}
	public void setCallbackTopic(String callbackTopic) {
		this.callbackTopic = callbackTopic;
	}
	public String getCallbackTag() {
		return callbackTag;
	}
	public void setCallbackTag(String callbackTag) {
		this.callbackTag = callbackTag;
	}
	public String getCallbackKey() {
		return callbackKey;
	}
	public void setCallbackKey(String callbackKey) {
		this.callbackKey = callbackKey;
	}
	public Map<String, String> getAuthParams() {
		return authParams;
	}
	public void setAuthParams(Map<String, String> authParams) {
		this.authParams = authParams;
	}
	public Map<String, String> getParams() {
		return params;
	}
	public void setParams(Map<String, String> params) {
		this.params = params;
	}
	public AddCreditsParams getAddCreditsParams() {
		return addCreditsParams;
	}
	public void setAddCreditsParams(AddCreditsParams addCreditsParams) {
		this.addCreditsParams = addCreditsParams;
	}
	
	/**
	 * 解码消息，接收mq消息使用
	 *
	 * @param msg
	 * @return
	 */
	public static AddCreditsMsgDto decode(byte[] msg) {
		String string = GZIPCompressUtil.ungzip(msg);
		if (string == null || string.isEmpty()) {
			return null;
		}
		return JSONObject.parseObject(string, AddCreditsMsgDto.class);
	}

	/**
	 * 编码消息，发送时使用
	 *
	 * @param subCreditsMsg
	 * @return
	 */
	public static byte[] encode(AddCreditsMsgDto subCreditsMsg) {
		String string = JSONObject.toJSONString(subCreditsMsg);
		try {
			byte[] str = string.getBytes("utf-8");
			return GZIPCompressUtil.gzip(str);
		} catch (UnsupportedEncodingException e) {
			return null;
		}
	}
}