package cn.com.duiba.api.enums.hbase;

import org.apache.commons.lang3.StringUtils;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/10/16 0016 11:20
 * 为了和之前区分开,建议使用H开头
 */
public enum CustomWebHBaseKeyEnum {
    H001("永辉膨胀红包-任务邀请记录"),
    H002("永辉膨胀红包-红包金额"),
    H003("oppo-发奖缓存"),
    H004("oppo-数据累计"),

    H010("永辉种红包-公告数据"),
    H011("永辉种红包-用户曾经正常访问过鱼塘标记"),
    H012("永辉种红包-用户的鱼数据"),
    H013("永辉种红包-用户已解锁的旧土地id列表"),
    H014("永辉种红包-用户已完成的新任务id列表"),
    H015("永辉种红包-用户邀请新人数"),
    H016("永辉种红包-用户下单数"),

    H020("前端缓存key"),

    H021("上海联通订单顺序号递增"),

    H022("华夏银行-微信用户绑定手机号"),
    H023("浙江银联-积分商城-任务组件-医保卡任务-用户奖励发放标志"),

    H999("默认不能使用");

    private String desc;

    CustomWebHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    /**
     * 定制活动web: activity-custom-web HBase key space
     */
    private static final String SPACE = "CUSWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    /**
     * 拼接字符串
     * 1.入参不能为null, 不然会变成__ 两个下划线
     *
     * @param strs
     * @return
     */
    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs, "_"));
    }
}
