package cn.com.duiba.api.enums.hbase;

import org.apache.commons.lang3.StringUtils;

/**
 * activity-cms-web
 *
 * @author 曾水平
 * @date 2020/7/7 10:55 上午
 */
public enum CMSWebHBaseKeyEnum {
    K001("红包广场前端页面内容数据"),
    K002("公告-新功能介绍已读标识"),
    K003("苏宁消消乐-红包炸弹更新标记"),
    K004("营销落地页模版-新手引导标示"),
    ;
    private String desc;

    CMSWebHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    /**
     * activity-cms-web HBase key space
     */
    private static final String SPACE = "ACWH";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    /**
     * 拼接字符串
     * 1.入参不能为null, 不然会变成__ 两个下划线
     *
     * @param strs
     * @return
     */
    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs, "_"));
    }
}
