package cn.com.duiba.api.enums;

import java.util.Objects;

/**
 * 开发者后台、兑吧管理后台
 * 手动发奖枚举
 * 因为要落同一个库，所以统一维护在此
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/6/4 10:46
 */
public enum DirectExchangePrizeTypeEnum {
    DEMO(0, "demo"),
    UNICOM_SICHUAN_E_COUPON(1, "四川联通-电子券"),
    UNICOM_SICHUAN_ENDPOINT_COUPON(2, "四川联通-终端券"),
    UNICOM_SICHUAN_PHONE_FLOW_PACKAGE(3, "四川联通-流量包"),
    UNICOM_SICHUAN_PHONE_BILL_PACKAGE(4, "四川联通-话费包"),
    UNICOM_SHANGHAI_NORMAL(5, "上海联通-通用"),
    UNICOM_HUNAN_NORMAL(6, "湖南联通-通用"),
    ;

    private final Integer code;
    private final String msg;

    DirectExchangePrizeTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public static DirectExchangePrizeTypeEnum getType(Integer code) {
        for (DirectExchangePrizeTypeEnum typeEnum : values()) {
            if (Objects.equals(typeEnum.getCode(), code)) {
                return typeEnum;
            }
        }
        return null;
    }
}
