package cn.com.duiba.api.enums.prize;

import java.util.HashMap;

/**
 * 奖品出奖逻辑类型
 * Created by xiaoxuda on 2019/3/21.
 */
public enum PrizeProcessTypeEnum {
	
    PLUGIN("plugin", "插件"),
    HDTOOL("hdtool", "活动工具"),
    INDEPENDENT("independent", "独立奖品池"),
    PRIZE_DIRECT("direct", "奖品直发"),

    ;

    private static HashMap<String, PrizeProcessTypeEnum> typeMap = new HashMap<>();
    static{
        for(PrizeProcessTypeEnum typeEnum : values()){
            typeMap.put(typeEnum.getType(), typeEnum);
        }
    }

    public static PrizeProcessTypeEnum getByType(String type){
        return typeMap.get(type);
    }

    private String type;
    private String desc;

    PrizeProcessTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getType() {
        return type;
    }
}
