package cn.com.duiba.api.bo;


import cn.com.duiba.api.enums.AccountBizTypeEnum;
import cn.com.duiba.api.enums.AccountSubTypeEnum;
import cn.com.duiba.api.enums.AccountActionTypeEnum;

import java.io.Serializable;

/**
 * Created by qianjue on 2018/5/2.
 */
public class ConsumerExpChangeDto implements Serializable{

	private static final long serialVersionUID = 5552503161667871936L;
	/**
	 * 用户ID
	 */
	private  Long  consumerId;
	/**
	 * AppId
	 */
	private  Long  appId;
	/**
	 * 出账/入账
	 */
	private AccountActionTypeEnum actionTypeEnum;

	/**
	 * 日志类型 2:增加经验
	 */
	private AccountSubTypeEnum subTypeEnum;
	/**
	 * 来源类型 1:每日登陆  2:兑换参与  3:活动参与
	 */
	private  Integer  channelType;
	/**
	 * 需要变更的经验值,为空则业务自行处理
	 */
	private  Long   expChange;

	/**
	 * biz_id为对应的获取经验的id
	 * 当获取经验方式为每日登录时，bizId为yyyyMMddHHmmss时间戳;
	 * 获取经验方式为兑换时，bizId为订单id;
	 * 获取经验方式为参与活动时，bizId为活动类型+子订单号
	 */
	private String bizId;

	/**
	 * biz_type 4：每日登陆 5：兑换 6：参与活动
	 */
	private AccountBizTypeEnum accountBizTypeEnum;

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public AccountActionTypeEnum getActionTypeEnum() {
		return actionTypeEnum;
	}

	public void setActionTypeEnum(
			AccountActionTypeEnum actionTypeEnum) {
		this.actionTypeEnum = actionTypeEnum;
	}

	public Integer getChannelType() {
		return channelType;
	}

	public void setChannelType(Integer channelType) {
		this.channelType = channelType;
	}

	public Long getExpChange() {
		return expChange;
	}

	public void setExpChange(Long expChange) {
		this.expChange = expChange;
	}

	public String getBizId() {
		return bizId;
	}

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public AccountSubTypeEnum getSubTypeEnum() {
		return subTypeEnum;
	}

	public void setSubTypeEnum(AccountSubTypeEnum subTypeEnum) {
		this.subTypeEnum = subTypeEnum;
	}

	public AccountBizTypeEnum getAccountBizTypeEnum() {
		return accountBizTypeEnum;
	}

	public void setAccountBizTypeEnum(AccountBizTypeEnum accountBizTypeEnum) {
		this.accountBizTypeEnum = accountBizTypeEnum;
	}
}
