package cn.com.duiba.api.bo.addcredits;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;

/**
 * ClassName:CreditsCallbackMessageDto<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 加积分请求mq消息解析
 * 
 * 基于 cn.com.duiba.order.center.api.dto.CreditsCallbackMessage 改造
 * 
 * 
 * @date 创建时间：2018/12/26 15:12
 * @since JDK 1.8
 **/
public class CreditsCallbackMessageDto implements Serializable {


	private static final long serialVersionUID = 7020165279644014518L;
	
	public static final String CALLBACK_TYPE_FAILED = "failed";
	public static final String CALLBACK_TYPE_CANCELLED = "cancelled";
	public static final String CALLBACK_TYPE_COMPLETED = "completed";

	private Map<String, String> params;
	private String appId;
	private String consumerId;
	private String callbackType; // failed,completed,cancelled
	//加积分 返回数据
	private String relationId;
	private String relationType;
	private String httpUrl;
	private String message;//数据格式  "{'status':'ok','errorMessage':'','bizId':'3028847','credits':'999999759824'}"
	
	//虚拟商品 返回数据用
	private String errorMessage;
	private String orderId;
	private String supplierOrderId;
	private String body;//数据格式   "{status:\"success\",credits:\"10000\",supplierBizId:\"no123456\"}"
	public Map<String, String> getParams() {
		return params;
	}
	public void setParams(Map<String, String> params) {
		this.params = params;
	}
	public String getAppId() {
		return appId;
	}
	public void setAppId(String appId) {
		this.appId = appId;
	}
	public String getConsumerId() {
		return consumerId;
	}
	public void setConsumerId(String consumerId) {
		this.consumerId = consumerId;
	}
	public String getCallbackType() {
		return callbackType;
	}
	public void setCallbackType(String callbackType) {
		this.callbackType = callbackType;
	}
	public String getRelationId() {
		return relationId;
	}
	public void setRelationId(String relationId) {
		this.relationId = relationId;
	}
	public String getRelationType() {
		return relationType;
	}
	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}
	public String getHttpUrl() {
		return httpUrl;
	}
	public void setHttpUrl(String httpUrl) {
		this.httpUrl = httpUrl;
	}
	public String getMessage() {
		return message;
	}
	public void setMessage(String message) {
		this.message = message;
	}
	public String getErrorMessage() {
		return errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public String getOrderId() {
		return orderId;
	}
	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}
	public String getSupplierOrderId() {
		return supplierOrderId;
	}
	public void setSupplierOrderId(String supplierOrderId) {
		this.supplierOrderId = supplierOrderId;
	}
	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}

	/**
	 * 解码消息，接收mq消息使用
	 *
	 * @param msg byte数组
	 * @return SubCreditsResultMsgDto
	 */
	public static CreditsCallbackMessageDto decode(byte[] msg) {
		String string = new String(msg, Charset.forName("utf-8"));
		if (StringUtils.isEmpty(string)) {
			return null;
		}
		return JSONObject.parseObject(string, CreditsCallbackMessageDto.class);
	}
}