package cn.com.duiba.api.bo.mq.alarmsms;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author JunAngLiu
 * @Title: DuibaAccountRiskParam
 * @Description:兑吧账户预警
 * @date 2019/5/1619:28
 */
public class DuibaAccountRiskParam {

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 金额
     */
    private Long money;


    /**
     * 解码消息，接收mq消息使用
     *
     * @param msg byte数组
     * @return AlarmSmsBaseParam
     */
    public static <T> T decode(byte[] msg, Class<T> clazz) {
        String string = new String(msg, Charset.forName("utf-8"));
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        return JSONObject.parseObject(string, clazz);
    }

    /**
     * 校验对象是否存在空属性
     *
     * @param obj          对象
     * @param excludeNames 选择忽略校验的属性名称List集合
     * @return boolean
     * @throws Exception
     */
    public static boolean isExistNullField(Object obj, List<String> excludeNames) throws Exception {
        if (excludeNames == null) {
            excludeNames = Collections.emptyList();
        }
        Field[] fs = obj.getClass().getDeclaredFields();
        boolean flag = false;
        for (Field f : fs) {
            f.setAccessible(true);
            if (!excludeNames.contains(f.getName()) && (f.get(obj) == null || "".equals(f.get(obj).toString()))) {
                flag = true;
                break;
            }
        }
        return flag;
    }


    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public Long getMoney() {
        return money;
    }

    public void setMoney(Long money) {
        this.money = money;
    }
}
