package cn.com.duiba.api.bo.order;

import java.io.Serializable;

/**
 * @author qianjue
 * @date 2018/12/6
 * @description: 实物发货订单的物流信息
 */
public class ObjectExpressDto implements Serializable {
    /**
     * 快递公司编码
     */
    private String  logisticsCode;
    /**
     * 快递公司名称
     */
    private String  logisticsName;
    /**
     * 快递单号
     */
    private String  expressOrderNum;
    /**
     * 本单快递对应的供应商商品id，多个用逗号分隔，如为空，表示全单只有一个快递
     */
    private String  itemIds;
    /**
     * 本单快递对应的供应商商品skuid，多个用逗号分隔
     */
    private String  skuIds;

    /**
     * 发货数量
     */
    private Long deliveryQuantity;

    public String getLogisticsCode() {
        return logisticsCode;
    }

    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    public String getLogisticsName() {
        return logisticsName;
    }

    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    public String getExpressOrderNum() {
        return expressOrderNum;
    }

    public void setExpressOrderNum(String expressOrderNum) {
        this.expressOrderNum = expressOrderNum;
    }

    public String getItemIds() {
        return itemIds;
    }

    public void setItemIds(String itemIds) {
        this.itemIds = itemIds;
    }

    public String getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(String skuIds) {
        this.skuIds = skuIds;
    }

    public Long getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(Long deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }
}
