package cn.com.duiba.api.enums;

/**
 * ClassName:ActivityOrderStutsEnum<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 活动子订单  各种状态枚举
 * @date 创建时间：2018/5/9  15:35
 * @since JDK 1.8
 **/
public enum ActivityOrderStutsEnum {

    CONSUME_CREDITS_INIT(0, "初始化"),
    CONSUME_CREDITS_PROCESSING(1,"处理中"),
    CONSUME_CREDITS_SUCCESS(2,"成功"),
    CONSUME_CREDITS_FAIL(3,"失败"),
    // 扣积分成功后 执行完业务 需要通知开发者最终结果
    CONSUME_CREDITS_NOTIFY(4, "已通知开发者"),

    ADD_CREDITS_INIT(0, "初始化"),
    ADD_CREDITS_PROCESSING(1,"加积分处理中"),
    ADD_CREDITS_SUCCESS(2,"加积分成功"),
    ADD_CREDITS_FAIL(3,"加积分失败"),

    EXCHANGE_NONE(0,"无需领奖"),
    EXCHANGE_WAIT(1,"待领将"),
    EXCHANGE_SUCCESS(2," 领奖成功"),
    EXCHANGE_FAIL(3," 领奖失败"),
    EXCHANGE_OVERDUE(4,"过期未领奖失效"),
    // 防止重复发奖 通过状态变更控制
    EXCHANGE_PROCESSING(5, "出奖中"),

    HDTOOL_STATUS_CREATE(0,"处理中"),
    HDTOOL_STATUS_SUCCESS(1,"处理成功"),
    HDTOOL_STATUS_FAIL (2,"处理失败");

    //编码
    private Integer code;
    //描述
    private String desc;

    ActivityOrderStutsEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}