package cn.com.duiba.api.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Objects;

/**
 *  兑吧商品类型枚举映射表
 */
public enum DuibaItemTypeEnum {
    OBJECT("object","实物"),
    QB("qb","QQ币"),
    PHONE_BILL("phonebill","话费"),
    COUPON("coupon","优惠劵"),
    VIRTUAL_ITEM("virtual","虚拟商品"),
    COLLECT_GOODS("collectGoods","集卡"),
    CREDITS("credits","积分"),
    PHONEBILLDINGZHI("phonebillDingzhi","话费"),
    PHONEFLOW("phoneflow","流量"),
    ALIPAY("alipay","支付宝"),
    APLIPAYSKU("aplipaySku","支付宝"),
    ALIPAYCODE("alipaycode","支付宝"),
    ALIPAYFAST("alipayfast","支付宝"),
    GAMECARD("gamecard","游戏充值卡"),
    HAPPYCODE("happyCode","开心码商品"),
    TURNTABLE("turntable","大转盘"),
    FAKE("fake","伪造类型"),
    CRYPTOCARD("cryptoCard","卡密"),

    ;

    private String type;
    private String desc;

    DuibaItemTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static DuibaItemTypeEnum getByType(String type){
        if(Objects.isNull(type)){
            return null;
        }
        for(DuibaItemTypeEnum DuibaItemTypeEnum : DuibaItemTypeEnum.values()){
            if(StringUtils.equals(type,DuibaItemTypeEnum.getType())){
                return DuibaItemTypeEnum;
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
