package cn.com.duiba.api.enums.hbase;

import org.apache.commons.lang3.StringUtils;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2019/10/16 0016 11:20
 * 为了和之前区分开,建议使用H开头
 */
public enum HdtoolWebHBaseKeyEnum {
    H01("情人节亲吻活动-活动值"),
    H02("情人节亲吻活动"),


    H99("默认不能使用");

    private String desc;

    HdtoolWebHBaseKeyEnum(String desc) {
        this.desc = desc;
    }

    /**
     * 定制活动web: htool-web HBase key space
     */
    private static final String SPACE = "HTOOL";

    public String getDesc() {
        return desc;
    }

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }

    /**
     * 拼接字符串
     * 1.入参不能为null, 不然会变成__ 两个下划线
     *
     * @param strs
     * @return
     */
    public String join(Object... strs) {
        return toString().concat(StringUtils.join(strs,"_"));
    }
}
