package cn.com.duiba.api.tools;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 统一内部日志<br>
 * 使用前，在logback文件中配置innerLog日志打印
 *
 * @see <a>http://cf.dui88.com:8090/pages/viewpage.action?pageId=4494009</a>
 * Created by zzy on 2017/2/27.
 */
public final class InnerLogger {
    private static final Logger log = LoggerFactory.getLogger("innerLog");
    private static final ThreadLocal<SimpleDateFormat> localDateFormat = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private InnerLogger() {
    }

    /**
     * 记录统一内部日志
     *
     * @param group 大类分组 必填
     * @param type  小类分组 必填
     * @param dpm   位置信息 可选
     * @param dcm   内容信息 可选
     * @param json  JSON格式，内容根据group和type自定义 可选
     */
    public static void log(int group, int type, String dpm, String dcm, JSONObject json) {
        JSONObject jsonLog = new JSONObject();
        jsonLog.put("group", group);
        jsonLog.put("type", type);
        jsonLog.put("time", localDateFormat.get().format(new Date()));
        jsonLog.put("dpm", dpm);
        jsonLog.put("dcm", dcm);
        jsonLog.put("json", json);
        log.info(jsonLog.toJSONString());
    }
}
