package cn.com.duiba.api.tools;

import org.apache.commons.lang.StringUtils;

import java.util.Random;

/**
 * @author LK.Hao
 * @date 2020/2/18
 * @description: 随机数的生成工具类
 */
public class RandomCodeUtil {

    public static final String[] ONLY_NUM_ARRAY = {"0","1","2","3","4","5","6","7","8","9"};

    public static final String[] ALL_ARRAY = {"0","1","2","3","4","5","6","7","8","9",
                                              "a","b","c","d","e","f","g","h","i","j",
                                              "k","m","n","p","q","r","s","t","u","v",
                                              "w","x","y","z"};
    /**
     * 生成一个n位的随机数字字符串
     * @return
     */
    public static String getNumCode(int size) {
        if(size <= 0){
            return StringUtils.EMPTY;
        }
        StringBuilder result = new StringBuilder();
        int length = ONLY_NUM_ARRAY.length;
        for(int i = 0; i < size; i ++){
            int location = new Random().nextInt(length);
            result.append(ONLY_NUM_ARRAY[location]);
        }
        return result.toString();
    }

    /**
     * 随机生成一个N位的字符串，包含数字和小写字母
     * @param size
     * @return
     */
    public static String  getCode(int size){
        if(size <= 0){
            return StringUtils.EMPTY;
        }
        StringBuilder result = new StringBuilder();
        int length = ALL_ARRAY.length;
        for(int i = 0; i < size; i ++){
            int location = new Random().nextInt(length);
            result.append(ALL_ARRAY[location]);
        }
        return result.toString();
    }
}
