package cn.com.duiba.duiba.base.service.api.duibaboot.oss.conf;

import cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.PrivateBucketOssTemplate;
import cn.com.duiba.duiba.base.service.api.duibaboot.oss.template.PublicBucketOssTemplate;
import com.aliyun.oss.OSSClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

import java.util.Map;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/7/21 2:48 下午
 */
@Slf4j
public class OssBeanDefinitionRegistryPostProcessor implements BeanDefinitionRegistryPostProcessor, EnvironmentAware {

    private OssProps ossProps;

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (Objects.isNull(ossProps) || MapUtils.isEmpty(ossProps.getOss())) {
            return;
        }
        for (Map.Entry<String, OssProps.OssClientProps> entity : ossProps.getOss().entrySet()) {
            final String beanNamePrefix = entity.getKey();
            final OssProps.OssClientProps ossProps = entity.getValue();
            final OSSClient ossClient = ossProps.newInstance();
            if (Objects.isNull(ossClient)) {
                return;
            }
            final BeanDefinitionBuilder bdb;
            if (ossProps.isPrivateBucket()) {
                bdb = BeanDefinitionBuilder.genericBeanDefinition(PrivateBucketOssTemplate.class);
            } else {
                bdb = BeanDefinitionBuilder.genericBeanDefinition(PublicBucketOssTemplate.class);
            }
            bdb.addPropertyValue("ossClient", ossClient)
                    .addPropertyValue("bucketName", ossProps.getBucketName())
                    .addPropertyValue("cdnDomain", ossProps.getCDNDomain())
                    .addPropertyValue("endPoint", ossProps.getEndPoint());

            final String beanName = beanNamePrefix + "OssTemplate";
            registry.registerBeanDefinition(beanName, bdb.getBeanDefinition());
            log.info("register bean {} successful", beanName);
        }
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {

    }

    @Override
    public void setEnvironment(Environment environment) {
        ossProps = Binder.get(environment).bindOrCreate(OssProps.prefix, OssProps.class);
    }
}
