package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import org.apache.ibatis.mapping.SqlCommandType;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2024/9/24 15:31
 */
public class SqlCommandAdapter {
    
    private static final Map<String, SqlCommandHandler> handlerMap = new HashMap<>();
    
    private SqlCommandAdapter() {}

    public static void register(SqlCommandHandler handler) {
        handlerMap.put(handler.sqlCommandType().name(), handler);
    }
    
    private static SqlCommandHandler get(SqlCommandType sqlCommandType) {
        return handlerMap.get(sqlCommandType.name());
    }
    
    public static String getTableName(SqlCommandType sqlCommandType, String sql) {
        SqlCommandHandler handler = get(sqlCommandType);
        if (handler == null) {
            return null;
        }
        return handler.getTableName(sql);
    }



    /**
     * 获取需要加密的参数index以及规则
     * @param sql sql
     * @param columns 加密配置
     * @return key：index，value：规则
     */
    public static Map<Integer, DbEncryptColumnRule> getNeedEncryptParamIndexRule(SqlCommandType sqlCommandType, String sql, Map<String, DbEncryptColumnRule> columns) {
        SqlCommandHandler handler = get(sqlCommandType);
        if (handler == null) {
            return Collections.emptyMap();
        }
        return handler.getNeedEncryptParamIndexRule(sql, columns);
    }
}
