package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.InitializingBean;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * @author lizhi
 * @date 2024/9/24 15:27
 */
public interface SqlCommandHandler extends InitializingBean {

    /**
     * sql类型
     * @return 类型枚举
     */
    @Nonnull
    SqlCommandType sqlCommandType();

    /**
     * 获取表名称
     * @param sql sql
     * @return 表名称
     */
    String getTableName(String sql);

    /**
     * 获取需要加密的参数index以及规则
     * @param sql sql
     * @param columns 加密配置
     * @return key：index，value：规则
     */
    Map<Integer, DbEncryptColumnRule> getNeedEncryptParamIndexRule(String sql, Map<String, DbEncryptColumnRule> columns);
}
