package cn.com.duiba.duiba.base.service.api.remoteservice.shorturl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.base.service.api.dto.shorturl.ShortUrlDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 短链服务
 *
 * @author zzy
 * @date 2023/9/26 18:22
 */
@AdvancedFeignClient
public interface RemoteShortUrlService {

    /**
     * 生成短链
     *
     * @param shortType 业务类型 必填
     * @param sourceUrl 原始链接 必填
     * @see cn.com.duiba.duiba.base.service.api.enums.ShortTypeEnum
     * @return 短链，例如：https://s.duiba.cn/fjsifjs
     */
    String generateShortUrl(Integer shortType, String sourceUrl);


    /**
     * 批量生成短链,若短链生成失败则结果集中不包含此链接
     * @param shortType 业务类型,参考ShortTypeEnum  必填
     * @param sourceUrls 原始链接 必填
     * @param keyLen 短链长度 选填 默认10
     * @return 短链map key=sourceUrl value=短链
     */
    Map<String, String> batchGenerateShortUrl(Integer shortType, Set<String> sourceUrls, Integer keyLen);

    /**
     * 通过短链解析原始链接
     *
     * @param shortUrl 短链
     * @return 不存在的短链、链接不合法返回null
     */
    String getSourceUrlByShortUrl(String shortUrl);

    /**
     * 根据key查询
     *
     * @param key 短链唯一key
     * @return 转换内容
     */
    ShortUrlDto findByKey(String key);

    /**
     * 保存
     *
     * @param shortType 业务类型,参考ShortTypeEnum  必填
     * @param sourceUrl 原始链接  必填
     * @param remark    备注  可选
     * @return 返回短链key
     */
    String save(Integer shortType, String sourceUrl, String remark);

    /**
     * 根据key更新
     *
     * @param key       key 必填
     * @param sourceUrl 链接 必填
     * @param remark    备注 可选
     * @return 更新成功数量
     */
    int updateSourceUrl(String key, String sourceUrl, String remark);

    /**
     * 根据条件查询，不分页
     *
     * @param shortType 短链类型
     * @param offset    分页查询
     * @param pageSize  分页查询
     * @return 转换内容
     */
    List<ShortUrlDto> selectPage(Integer shortType, Integer offset, Integer pageSize);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param shortType 短链类型
     * @return 符合条件的记录数
     */
    Integer selectCount(Integer shortType);
}
