/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.impl;

import cn.com.duiba.duiba.base.service.api.mybatis.plugins.config.DbEncryptColumnRule;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandAdapter;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.SqlCommandHandler;
import cn.com.duiba.duiba.base.service.api.mybatis.plugins.handler.command.impl.AbstractSqlCommandHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SqlSessionTemplate.class, SqlSessionFactoryBean.class, SqlSessionFactory.class})
public class InsertSqlHandler
extends AbstractSqlCommandHandler
implements SqlCommandHandler {
    @Override
    @NotNull
    public SqlCommandType sqlCommandType() {
        return SqlCommandType.INSERT;
    }

    @Override
    public String getTableName(String sql) {
        return this.getTableName(sql, "(");
    }

    @Override
    protected int getSpecialTbIndex(String sql) {
        return this.getSpecialTbIndex(sql, "into ");
    }

    @Override
    public Map<Integer, DbEncryptColumnRule> getNeedEncryptParamIndexRule(String sql, Map<String, DbEncryptColumnRule> columns) {
        LinkedHashMap<Integer, DbEncryptColumnRule> indexRuleMap = new LinkedHashMap<Integer, DbEncryptColumnRule>();
        if (StringUtils.isBlank((CharSequence)sql)) {
            return indexRuleMap;
        }
        int leftBracketIndex = sql.indexOf("(");
        int rightBracketIndex = sql.indexOf(")");
        if (leftBracketIndex < 0 || rightBracketIndex < 0) {
            return indexRuleMap;
        }
        String[] split = sql.substring(leftBracketIndex + "(".length(), rightBracketIndex).split(",");
        LinkedHashMap<Integer, DbEncryptColumnRule> nameIndexRuleMap = new LinkedHashMap<Integer, DbEncryptColumnRule>();
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            DbEncryptColumnRule rule = columns.get(name.trim());
            if (rule == null) continue;
            nameIndexRuleMap.put(i, rule);
        }
        if (MapUtils.isEmpty(nameIndexRuleMap)) {
            return indexRuleMap;
        }
        int size = split.length;
        int valueIndex = 0;
        rightBracketIndex = sql.indexOf(")", rightBracketIndex + 1);
        while (rightBracketIndex >= 0) {
            for (Map.Entry entry : nameIndexRuleMap.entrySet()) {
                indexRuleMap.put(valueIndex * size + (Integer)entry.getKey(), (DbEncryptColumnRule)entry.getValue());
            }
            rightBracketIndex = sql.indexOf(")", rightBracketIndex + 1);
            ++valueIndex;
        }
        return indexRuleMap;
    }

    public void afterPropertiesSet() throws Exception {
        SqlCommandAdapter.register(this);
    }
}

