package cn.com.duiba.duiba.base.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 短链业务类型
 *
 * @author zzy
 * @date 2023/09/23 09:44
 */
@Getter
@AllArgsConstructor
public enum ShortTypeEnum {

    QUANYI_GOODS_ORDER_TAKE(1, "权益商品订单领取", true, false),
    QUANYI_PACKAGE_TRANS(2, "权益卡券包业务参数转换", false, false),
    YUEXIANHUO_QRCODE(3, "悦鲜活瓶盖二维码短链", true, false),
    ;

    private final Integer code;

    private final String desc;

    /**
     * 是否是重定向短链
     */
    private final boolean isRedirect;

    /**
     * 是否支持分页查询
     */
    private final boolean isSupportPageQuery;

    private static final Map<Integer, ShortTypeEnum> ENUM_MAP;

    static {
        Map<Integer, ShortTypeEnum> temp = new HashMap<>();
        for (ShortTypeEnum typeEnum : values()) {
            temp.put(typeEnum.getCode(), typeEnum);
        }
        ENUM_MAP = Collections.unmodifiableMap(temp);
    }

    public static ShortTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    /**
     * 是否是重定向短链
     *
     * @param code 枚举值
     * @return true-是，false-否
     */
    public static boolean isRedirect(Integer code) {
        ShortTypeEnum shortTypeEnum = getByCode(code);
        if (shortTypeEnum == null) {
            return false;
        }
        return shortTypeEnum.isRedirect();
    }

    /**
     * 是重定向短链
     *
     * @return
     */
    public static Set<ShortTypeEnum> getAllRedirect() {
        return Arrays.stream(values()).filter(ShortTypeEnum::isRedirect).collect(Collectors.toSet());
    }
}
