package cn.com.duiba.duiba.base.service.api.remoteservice.division;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.base.service.api.dto.division.AdministrativeDivisionDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdministrativeDivisionService {

    /**
     * 根据code查询下级所有行政区域
     *
     * @param code 行政编码
     *             支持完整code或者shortCode。
     *             null或者空字符串将会视作查询第一级的所有省、直辖市、自治区、特别行政区
     * @return 隶属于该行政地区下的所有行政区域
     */
    List<AdministrativeDivisionDto> selectChildrenByCode(String code);

    /**
     * 根据code查询行政区域
     *
     * @param code 支持完整code 或者 shortCode
     */
    AdministrativeDivisionDto selectByCode(String code);

    /**
     * 根据code查询每一级的行政区域列表
     * EX: 330000 -> [浙江]
     * EX: 330100 -> [浙江,杭州]
     * EX: 330106 -> [浙江,杭州,西湖]
     * EX: 330106007 -> [浙江,杭州,西湖,古荡]
     *
     * @param code 行政编码
     * @return 每个层级的行政编码
     */
    List<AdministrativeDivisionDto> selectEveryLevelByCode(String code);
}
