package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.message.*;

import java.util.ArrayList;
import java.util.List;

public enum NullMessage implements Transaction, Event, Metric, Trace, Heartbeat, ForkedTransaction, ForkableTransaction {
    TRANSACTION,
    EVENT,
    METRIC,
    TRACE,
    HEARTBEAT,
    FORKED_TRANSACTION;

    private static String DEFAULT = "";

    @Override
    public Transaction addChild(Message message) {
        return this;
    }

    @Override
    public void addData(String keyValuePairs) {
    }

    @Override
    public void addData(String key, Object value) {
    }

    @Override
    public void close() {

    }

    @Override
    public void complete() {
    }

    @Override
    public ForkedTransaction doFork() {
        return this;
    }

    @Override
    public ForkableTransaction forFork() {
        return this;
    }

    @Override
    public List<Message> getChildren() {
        return new ArrayList<Message>();
    }

    @Override
    public Object getData() {
        return DEFAULT;
    }

    @Override
    public long getDurationInMicros() {
        return 0;
    }

    @Override
    public void setDurationInMicros(long durationInMicros) {
    }

    @Override
    public long getDurationInMillis() {
        return 0;
    }

    @Override
    public void setDurationInMillis(long duration) {
    }

    @Override
    public String getMessageId() {
        return DEFAULT;
    }

    @Override
    public void setMessageId(String messageId) {
    }

    @Override
    public String getName() {
        return DEFAULT;
    }

    public String getParentMessageId() {
        return DEFAULT;
    }

    public long getRawDurationInMicros() {
        return 0;
    }

    public String getRootMessageId() {
        return DEFAULT;
    }

    @Override
    public String getStatus() {
        return DEFAULT;
    }

    @Override
    public void setStatus(String status) {
    }

    @Override
    public void setStatus(Throwable e) {
    }

    @Override
    public long getTimestamp() {
        return 0;
    }

    @Override
    public void setTimestamp(long timestamp) {
    }

    @Override
    public String getType() {
        return DEFAULT;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public Message join() {
        return this;
    }

    @Override
    public void setDurationStart(long durationStart) {
    }

    @Override
    public void setSuccessStatus() {
    }

}
