package cn.com.duiba.cat.model.configuration;

import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.model.configuration.property.entity.PropertyConfig;

import java.util.List;

public interface ClientConfigService {

    int getClientConnectTimeout();

    String getDomain();

    int getLongConfigThreshold(String key);

    int getLongThresholdByDuration(String key, int duration);

    String getRouters();

    double getSamplingRate();

    List<Server> getServers();

    boolean isMessageBlock();

    MessageType parseMessageType(MessageTree tree);

    void refreshConfig(PropertyConfig config);

    void refreshConfig();

}
