package cn.com.duiba.cat.model.configuration.client.entity;

import cn.com.duiba.cat.model.configuration.client.BaseEntity;
import cn.com.duiba.cat.model.configuration.client.Constants;
import cn.com.duiba.cat.model.configuration.client.IVisitor;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Server extends BaseEntity<Server> {

    private String  ip;
    private int     port     = 2280;
    private int     httpPort = 8080;
    private boolean enabled  = true;

    public Server() {
    }

    public Server(String ip) {
        this.ip = ip;
    }

    public Server(String ip, int httpPort) {
        this.ip = ip;
        this.httpPort = httpPort;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitServer(this);
    }

    @Override
    public void mergeAttributes(Server other) {
        assertAttributeEquals(other, Constants.ENTITY_SERVER, Constants.ATTR_IP, ip, other.getIp());

        port = other.getPort();

        httpPort = other.getHttpPort();

        enabled = other.isEnabled();
    }

    public String getIp() {
        return ip;
    }

    public Server setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public int getPort() {
        return port;
    }

    public Server setPort(int port) {
        this.port = port;
        return this;
    }

    public int getHttpPort() {
        return httpPort;
    }

    public Server setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;

        if (o == null || getClass() != o.getClass()) return false;

        Server server = (Server) o;

        return new EqualsBuilder().append(port, server.port).append(httpPort, server.httpPort).append(enabled, server.enabled).append(ip, server.ip).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(ip).append(port).append(httpPort).append(enabled).toHashCode();
    }

    public boolean isEnabled() {
        return enabled;
    }

    public Server setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

}
