/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.analyzer;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.analyzer.DurationComputer;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.ProblemLongType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionAggregator {
    private static TransactionAggregator instance = new TransactionAggregator();
    private volatile ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> transactions = new ConcurrentHashMap();

    public static TransactionAggregator getInstance() {
        return instance;
    }

    private TransactionData createTransactionData(String type, String name) {
        return new TransactionData(type, name);
    }

    private ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> getAndResetTransactions() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> cloned = this.transactions;
        this.transactions = new ConcurrentHashMap();
        for (Map.Entry<String, ConcurrentHashMap<String, TransactionData>> entry : cloned.entrySet()) {
            String type = entry.getKey();
            this.transactions.putIfAbsent(type, new ConcurrentHashMap());
        }
        return cloned;
    }

    public String getDomain() {
        return Cat.getManager().getDomain();
    }

    public void logBatchTransaction(String type, String name, int count, int error, long sum) {
        this.makeSureTransactionExist(type, name).add(count, error, sum);
    }

    void logTransaction(Transaction t) {
        this.makeSureTransactionExist(t.getType(), t.getName()).add(t);
    }

    private TransactionData makeSureTransactionExist(String type, String name) {
        TransactionData data;
        ConcurrentHashMap<String, TransactionData> oldValue;
        ConcurrentHashMap<String, TransactionData> item = this.transactions.get(type);
        if (null == item && (oldValue = this.transactions.putIfAbsent(type, item = new ConcurrentHashMap())) != null) {
            item = oldValue;
        }
        if (null == (data = item.get(name))) {
            data = this.createTransactionData(type, name);
            TransactionData oldValue2 = item.putIfAbsent(name, data);
            if (oldValue2 == null) {
                return data;
            }
            return oldValue2;
        }
        return data;
    }

    void sendTransactionData() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionData>> transactions = this.getAndResetTransactions();
        boolean hasData = false;
        block0: for (Map map : transactions.values()) {
            for (TransactionData transactionData : map.values()) {
                if (transactionData.getCount().get() <= 0) continue;
                hasData = true;
                continue block0;
            }
        }
        if (hasData) {
            Transaction t = Cat.newTransaction("System", this.getClass().getSimpleName());
            MessageTree messageTree = Cat.getManager().getThreadLocalMessageTree();
            messageTree.setDomain(this.getDomain());
            messageTree.setDiscardPrivate(false);
            for (Map map : transactions.values()) {
                for (TransactionData data : map.values()) {
                    if (data.getCount().get() <= 0) continue;
                    Transaction tmp = Cat.newTransaction(data.getType(), data.getName());
                    StringBuilder sb = new StringBuilder(32);
                    sb.append('@').append(data.getCount().get()).append(";");
                    sb.append(data.getFail().get()).append(";");
                    sb.append(data.getSum().get()).append(";");
                    sb.append(data.getDurationString()).append(";").append(data.getLongDurationString());
                    tmp.addData(sb.toString());
                    tmp.setSuccessStatus();
                    tmp.complete();
                }
            }
            t.setSuccessStatus();
            t.complete();
        }
    }

    private int checkAndGetLongThreshold(String type, int duration) {
        ClientConfigService config = Cat.getManager().getConfigService();
        ProblemLongType longType = ProblemLongType.findByMessageType(type);
        if (longType != null) {
            switch (longType) {
                case LONG_CACHE: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_CACHE.getName(), duration);
                }
                case LONG_CALL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_CALL.getName(), duration);
                }
                case LONG_SERVICE: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_SERVICE.getName(), duration);
                }
                case LONG_SQL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_SQL.getName(), duration);
                }
                case LONG_URL: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_URL.getName(), duration);
                }
                case LONG_MQ: {
                    return config.getLongThresholdByDuration(ProblemLongType.LONG_MQ.getName(), duration);
                }
            }
        }
        return -1;
    }

    public class TransactionData {
        private String type;
        private String name;
        private AtomicInteger count = new AtomicInteger();
        private AtomicInteger fail = new AtomicInteger();
        private AtomicLong sum = new AtomicLong();
        private ConcurrentHashMap<Integer, AtomicInteger> durations = new ConcurrentHashMap();
        private ConcurrentHashMap<Integer, AtomicInteger> longDurations = new ConcurrentHashMap();

        TransactionData(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public TransactionData add(int count, int error, long sum) {
            this.count.addAndGet(count);
            this.sum.addAndGet(sum);
            this.fail.addAndGet(error);
            if (count == 1) {
                int duration = DurationComputer.computeDuration((int)sum);
                AtomicInteger durationCount = this.durations.get(duration);
                if (durationCount == null) {
                    this.durations.put(duration, new AtomicInteger(1));
                } else {
                    durationCount.incrementAndGet();
                }
            }
            return this;
        }

        public TransactionData add(Transaction t) {
            int duration;
            AtomicInteger count;
            this.count.incrementAndGet();
            this.sum.getAndAdd(t.getDurationInMillis());
            if (!t.isSuccess()) {
                this.fail.incrementAndGet();
            }
            if ((count = this.durations.get(duration = DurationComputer.computeDuration((int)t.getDurationInMillis()))) == null) {
                count = new AtomicInteger(0);
                AtomicInteger oldCount = this.durations.putIfAbsent(duration, count);
                if (oldCount != null) {
                    count = oldCount;
                }
            }
            count.incrementAndGet();
            int longDuration = TransactionAggregator.this.checkAndGetLongThreshold(t.getType(), duration);
            if (longDuration > 0) {
                AtomicInteger longCount = this.longDurations.get(longDuration);
                if (longCount == null) {
                    longCount = new AtomicInteger(0);
                    AtomicInteger oldLongCount = this.longDurations.putIfAbsent(longDuration, longCount);
                    if (oldLongCount != null) {
                        longCount = oldLongCount;
                    }
                }
                longCount.incrementAndGet();
            }
            return this;
        }

        AtomicInteger getCount() {
            return this.count;
        }

        String getDurationString() {
            return this.buildDurationString(this.durations);
        }

        private String buildDurationString(ConcurrentHashMap<Integer, AtomicInteger> durations) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<Integer, AtomicInteger> entry : durations.entrySet()) {
                Integer key = entry.getKey();
                AtomicInteger value = entry.getValue();
                if (first) {
                    sb.append(key).append(',').append(value);
                    first = false;
                    continue;
                }
                sb.append('|').append(key).append(',').append(value);
            }
            return sb.toString();
        }

        String getLongDurationString() {
            return this.buildDurationString(this.longDurations);
        }

        AtomicInteger getFail() {
            return this.fail;
        }

        public String getName() {
            return this.name;
        }

        public AtomicLong getSum() {
            return this.sum;
        }

        public String getType() {
            return this.type;
        }
    }
}

