/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.internal;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.ForkableTransaction;
import cn.com.duiba.cat.message.Message;
import cn.com.duiba.cat.message.Transaction;
import cn.com.duiba.cat.message.internal.AbstractMessage;
import cn.com.duiba.cat.message.internal.DefaultForkableTransaction;
import cn.com.duiba.cat.message.spi.MessageManager;
import cn.com.duiba.cat.message.spi.MessageTree;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.ProblemLongType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultTransaction
extends AbstractMessage
implements Transaction {
    private static Map<String, Integer> map = new ConcurrentHashMap<String, Integer>();
    private static ConcurrentHashMap<Long, ConcurrentHashMap<String, AtomicInteger>> count = new ConcurrentHashMap();
    private long durationInMicro = -1L;
    private long durationStart;
    private List<Message> children;
    private MessageManager manager;
    private boolean standalone;

    public DefaultTransaction(String type, String name) {
        super(type, name);
        this.durationStart = System.nanoTime();
    }

    public DefaultTransaction(String type, String name, MessageManager manager) {
        super(type, name);
        this.manager = manager;
        this.standalone = true;
        this.durationStart = System.nanoTime();
    }

    public static void clearCache() {
        long time = System.currentTimeMillis() / 1000L / 60L - 3L;
        HashSet<Long> removeKeys = new HashSet<Long>();
        for (Long l : count.keySet()) {
            if (l > time) continue;
            removeKeys.add(l);
        }
        for (Long l : removeKeys) {
            count.remove(l);
        }
    }

    @Override
    public DefaultTransaction addChild(Message message) {
        if (this.children == null) {
            this.children = new ArrayList<Message>();
        }
        this.children.add(message);
        return this;
    }

    @Override
    public void complete() {
        try {
            if (!this.isCompleted()) {
                if (this.durationInMicro == -1L) {
                    this.durationInMicro = (System.nanoTime() - this.durationStart) / 1000L;
                }
                this.setCompleted(true);
                if (this.manager != null && this.isProblem(this, this.manager, this.type, this.durationInMicro / 1000L)) {
                    this.manager.getThreadLocalMessageTree().setDiscardPrivate(false);
                }
                if (this.manager != null) {
                    this.manager.end(this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public ForkableTransaction forFork() {
        MessageTree tree = this.manager.getThreadLocalMessageTree();
        String rootMessageId = tree.getRootMessageId();
        String messageId = tree.getMessageId();
        if (messageId == null) {
            messageId = Cat.createMessageId();
            tree.setMessageId(messageId);
        }
        if (rootMessageId == null) {
            rootMessageId = messageId;
        }
        DefaultForkableTransaction forkable = new DefaultForkableTransaction(rootMessageId, messageId);
        this.addChild(forkable);
        tree.addForkableTransaction(forkable);
        return forkable;
    }

    @Override
    public List<Message> getChildren() {
        if (this.children == null) {
            return new ArrayList<Message>();
        }
        return this.children;
    }

    @Override
    public long getDurationInMicros() {
        int len;
        if (this.durationInMicro >= 0L) {
            return this.durationInMicro;
        }
        long duration = 0L;
        int n = len = this.children == null ? 0 : this.children.size();
        if (len > 0) {
            Message lastChild = this.children.get(len - 1);
            if (lastChild instanceof Transaction) {
                Transaction trx = (Transaction)lastChild;
                duration = (trx.getTimestamp() - this.getTimestamp()) * 1000L + trx.getRawDurationInMicros();
            } else {
                duration = (lastChild.getTimestamp() - this.getTimestamp()) * 1000L;
            }
        }
        return duration;
    }

    @Override
    public void setDurationInMicros(long duration) {
        this.durationInMicro = duration;
    }

    @Override
    public long getDurationInMillis() {
        return this.getDurationInMicros() / 1000L;
    }

    @Override
    public void setDurationInMillis(long duration) {
        this.durationInMicro = duration * 1000L;
    }

    protected MessageManager getManager() {
        return this.manager;
    }

    @Override
    public long getRawDurationInMicros() {
        return this.durationInMicro;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    private boolean isProblem(Transaction t, MessageManager manager, String type, long duration) {
        boolean problem;
        if (t.isSuccess()) {
            Integer value = map.get(type);
            if (value != null) {
                problem = duration > (long)value.intValue();
            } else {
                int threshold = Integer.MAX_VALUE;
                ClientConfigService config = manager.getConfigService();
                ProblemLongType longType = ProblemLongType.findByMessageType(type);
                if (longType != null) {
                    switch (longType) {
                        case LONG_CACHE: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_CACHE.getName());
                            break;
                        }
                        case LONG_CALL: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_CALL.getName());
                            break;
                        }
                        case LONG_SERVICE: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_SERVICE.getName());
                            break;
                        }
                        case LONG_SQL: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_SQL.getName());
                            break;
                        }
                        case LONG_URL: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_URL.getName());
                            break;
                        }
                        case LONG_MQ: {
                            threshold = config.getLongConfigThreshold(ProblemLongType.LONG_MQ.getName());
                        }
                    }
                }
                map.put(type, threshold);
                problem = duration > (long)threshold && this.recordProblem(t.getTimestamp(), t.getType() + t.getName());
            }
        } else {
            problem = this.recordProblem(t.getTimestamp(), t.getType() + t.getName());
        }
        return problem;
    }

    private boolean recordProblem(long time, String id) {
        try {
            AtomicInteger oldValue;
            AtomicInteger value;
            long minute = time / 1000L / 60L;
            ConcurrentHashMap<String, AtomicInteger> count = DefaultTransaction.count.get(minute);
            if (count == null) {
                count = new ConcurrentHashMap();
                ConcurrentHashMap<String, AtomicInteger> oldCount = DefaultTransaction.count.putIfAbsent(minute, count);
                if (oldCount != null) {
                    count = oldCount;
                }
            }
            if ((value = count.get(id)) == null && (oldValue = count.putIfAbsent(id, value = new AtomicInteger(0))) != null) {
                value = oldValue;
            }
            return value.incrementAndGet() <= 60;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setDurationStart(long durationStart) {
        this.durationStart = durationStart;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }
}

