/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cat.message.io;

import cn.com.duiba.cat.Cat;
import cn.com.duiba.cat.message.internal.MessageIdFactory;
import cn.com.duiba.cat.model.configuration.ClientConfigService;
import cn.com.duiba.cat.model.configuration.DefaultClientConfigService;
import cn.com.duiba.cat.model.configuration.client.entity.Server;
import cn.com.duiba.cat.util.Pair;
import cn.com.duiba.cat.util.Splitters;
import cn.com.duiba.cat.util.StringUtils;
import cn.com.duiba.cat.util.Threads;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager
implements Threads.Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private static ChannelManager instance = new ChannelManager();
    private ClientConfigService configService = DefaultClientConfigService.getInstance();
    private Bootstrap bootstrap;
    private boolean active = true;
    private int channelStalledTimes = 0;
    private ChannelHolder activeChannelHolder;
    private MessageIdFactory idFactory = MessageIdFactory.getInstance();
    private AtomicInteger attempts = new AtomicInteger();
    private int reconnectCount;

    private ChannelManager() {
        List<Server> servers = this.configService.getServers();
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (Server server : servers) {
            if (!server.isEnabled()) continue;
            addresses.add(new InetSocketAddress(server.getIp(), server.getPort()));
        }
        NioEventLoopGroup group = new NioEventLoopGroup(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
            }
        });
        this.bootstrap = bootstrap;
        String routerConfig = this.configService.getRouters();
        if (StringUtils.isNotEmpty(routerConfig)) {
            List<InetSocketAddress> configuredAddresses = this.parseSocketAddress(routerConfig);
            ChannelHolder holder = this.initChannel(configuredAddresses, routerConfig);
            if (holder != null) {
                this.activeChannelHolder = holder;
            } else {
                this.activeChannelHolder = new ChannelHolder();
                this.activeChannelHolder.setServerAddresses(configuredAddresses);
            }
        } else {
            ChannelHolder holder = this.initChannel(addresses, null);
            if (holder != null) {
                this.activeChannelHolder = holder;
            } else {
                this.activeChannelHolder = new ChannelHolder();
                this.activeChannelHolder.setServerAddresses(addresses);
            }
        }
    }

    public static ChannelManager getInstance() {
        return instance;
    }

    public ChannelFuture channel() {
        ChannelFuture future;
        if (this.activeChannelHolder != null && this.checkWritable(future = this.activeChannelHolder.getActiveFuture())) {
            return future;
        }
        return null;
    }

    private boolean checkActive(ChannelFuture future) {
        boolean isActive = false;
        if (future != null) {
            Channel channel = future.channel();
            if (channel.isActive() && channel.isOpen()) {
                isActive = true;
            } else {
                LOGGER.error("channel buf is not active ,current channel " + future.channel().remoteAddress());
            }
        }
        return isActive;
    }

    private void checkServerChanged() {
        Pair<Boolean, String> pair = this.routerConfigChanged();
        if (pair.getKey().booleanValue()) {
            LOGGER.info("router config changed :" + pair.getValue());
            String servers = pair.getValue();
            List<InetSocketAddress> serverAddresses = this.parseSocketAddress(servers);
            ChannelHolder newHolder = this.initChannel(serverAddresses, servers);
            if (newHolder != null) {
                if (newHolder.isConnectChanged()) {
                    ChannelHolder last = this.activeChannelHolder;
                    this.activeChannelHolder = newHolder;
                    this.closeChannelHolder(last);
                    LOGGER.info("switch active channel to " + this.activeChannelHolder);
                } else {
                    this.activeChannelHolder = newHolder;
                }
            }
        }
    }

    private boolean checkWritable(ChannelFuture future) {
        boolean isWritable = false;
        if (future != null) {
            Channel channel = future.channel();
            if (channel.isActive() && channel.isOpen()) {
                if (channel.isWritable()) {
                    isWritable = true;
                } else {
                    channel.flush();
                }
            } else {
                int count = this.attempts.incrementAndGet();
                if (count % 1000 == 0 || count == 1) {
                    LOGGER.error("channel buf is is close when send msg! Attempts: " + count);
                }
            }
        }
        return isWritable;
    }

    private void closeChannel(ChannelFuture channel) {
        try {
            if (channel != null) {
                SocketAddress address = channel.channel().remoteAddress();
                if (address != null) {
                    LOGGER.info("close channel " + address);
                }
                channel.channel().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeChannelHolder(ChannelHolder channelHolder) {
        try {
            ChannelFuture channel = channelHolder.getActiveFuture();
            this.closeChannel(channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ChannelFuture createChannel(InetSocketAddress address) {
        block3: {
            LOGGER.info("start connect server" + address.toString());
            ChannelFuture future = null;
            try {
                future = this.bootstrap.connect((SocketAddress)address);
                future.awaitUninterruptibly((long)this.configService.getClientConnectTimeout(), TimeUnit.MILLISECONDS);
                if (future.isSuccess()) {
                    LOGGER.info("Connected to CAT server at " + address);
                    return future;
                }
                LOGGER.error("Error when try connecting to " + address);
                this.closeChannel(future);
            }
            catch (Throwable e) {
                LOGGER.error("Error when connect server " + address.getAddress(), e);
                if (future == null) break block3;
                this.closeChannel(future);
            }
        }
        return null;
    }

    private void doubleCheckActiveServer(ChannelHolder channelHolder) {
        try {
            if (this.isChannelStalled(channelHolder)) {
                this.closeChannelHolder(this.activeChannelHolder);
                channelHolder.setActiveIndex(-1);
            }
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return "netty-channel-health-check";
    }

    private ChannelHolder initChannel(List<InetSocketAddress> addresses, String serverConfig) {
        try {
            int len = addresses.size();
            for (int i = 0; i < len; ++i) {
                InetSocketAddress address = addresses.get(i);
                String hostAddress = address.getAddress().getHostAddress();
                ChannelHolder holder = null;
                if (this.activeChannelHolder != null && hostAddress.equals(this.activeChannelHolder.getIp())) {
                    holder = new ChannelHolder();
                    holder.setActiveFuture(this.activeChannelHolder.getActiveFuture()).setConnectChanged(false);
                } else {
                    ChannelFuture future = this.createChannel(address);
                    if (future != null) {
                        holder = new ChannelHolder();
                        holder.setActiveFuture(future).setConnectChanged(true);
                    }
                }
                if (holder == null) continue;
                holder.setActiveIndex(i).setIp(hostAddress);
                holder.setActiveServerConfig(serverConfig).setServerAddresses(addresses);
                LOGGER.info("success when init CAT server, new active holder" + holder.toString());
                return holder;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (InetSocketAddress address : addresses) {
                sb.append(address.toString()).append(";");
            }
            LOGGER.info("Error when init CAT server " + sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isChannelStalled(ChannelHolder holder) {
        ChannelFuture future = holder.getActiveFuture();
        boolean active = this.checkActive(future);
        if (!active) {
            return ++this.channelStalledTimes % 3 == 0;
        }
        if (this.channelStalledTimes > 0) {
            --this.channelStalledTimes;
        }
        return false;
    }

    private List<InetSocketAddress> parseSocketAddress(String content) {
        try {
            List<String> strs = Splitters.by(";").noEmptyItem().split(content);
            ArrayList<InetSocketAddress> address = new ArrayList<InetSocketAddress>();
            for (String str : strs) {
                List<String> items = Splitters.by(":").noEmptyItem().split(str);
                address.add(new InetSocketAddress(items.get(0), Integer.parseInt(items.get(1))));
            }
            return address;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList<InetSocketAddress>();
        }
    }

    private void reconnectDefaultServer(ChannelFuture activeFuture, List<InetSocketAddress> serverAddresses) {
        try {
            int reconnectServers = this.activeChannelHolder.getActiveIndex();
            if (reconnectServers == -1) {
                reconnectServers = serverAddresses.size();
            }
            for (int i = 0; i < reconnectServers; ++i) {
                ChannelFuture future = this.createChannel(serverAddresses.get(i));
                if (future == null) continue;
                this.activeChannelHolder.setActiveFuture(future);
                this.activeChannelHolder.setActiveIndex(i);
                this.closeChannel(activeFuture);
                break;
            }
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private Pair<Boolean, String> routerConfigChanged() {
        String routerConfig = this.configService.getRouters();
        if (!StringUtils.isEmpty(routerConfig) && !routerConfig.equals(this.activeChannelHolder.getActiveServerConfig())) {
            return new Pair<Boolean, String>(true, routerConfig);
        }
        return new Pair<Boolean, String>(false, routerConfig);
    }

    @Override
    public void run() {
        while (this.active) {
            if (Cat.isEnabled()) {
                ++this.reconnectCount;
                if (this.reconnectCount % 10 == 0) {
                    this.idFactory.saveMark();
                    this.checkServerChanged();
                }
                ChannelFuture activeFuture = this.activeChannelHolder.getActiveFuture();
                List<InetSocketAddress> serverAddresses = this.activeChannelHolder.getServerAddresses();
                this.doubleCheckActiveServer(this.activeChannelHolder);
                this.reconnectDefaultServer(activeFuture, serverAddresses);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void shutdown() {
        this.active = false;
    }

    public class ChannelHolder {
        private ChannelFuture activeFuture;
        private int activeIndex = -1;
        private String activeServerConfig;
        private List<InetSocketAddress> serverAddresses;
        private String ip;
        private boolean connectChanged;

        public ChannelFuture getActiveFuture() {
            return this.activeFuture;
        }

        public ChannelHolder setActiveFuture(ChannelFuture activeFuture) {
            this.activeFuture = activeFuture;
            return this;
        }

        public int getActiveIndex() {
            return this.activeIndex;
        }

        public ChannelHolder setActiveIndex(int activeIndex) {
            this.activeIndex = activeIndex;
            return this;
        }

        public String getActiveServerConfig() {
            return this.activeServerConfig;
        }

        public ChannelHolder setActiveServerConfig(String activeServerConfig) {
            this.activeServerConfig = activeServerConfig;
            return this;
        }

        public String getIp() {
            return this.ip;
        }

        public ChannelHolder setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public List<InetSocketAddress> getServerAddresses() {
            return this.serverAddresses;
        }

        public ChannelHolder setServerAddresses(List<InetSocketAddress> serverAddresses) {
            this.serverAddresses = serverAddresses;
            return this;
        }

        public boolean isConnectChanged() {
            return this.connectChanged;
        }

        public ChannelHolder setConnectChanged(boolean connectChanged) {
            this.connectChanged = connectChanged;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("active future :").append(this.activeFuture.channel().remoteAddress());
            sb.append(" index:").append(this.activeIndex);
            sb.append(" ip:").append(this.ip);
            sb.append(" server config:").append(this.activeServerConfig);
            return sb.toString();
        }
    }
}

